<?php

/**
 * The file for header all actions
 *
 *
 * @package Smart Agency
 */

function smart_agency_header_logo_output()
{
	$smart_agency_mlogo_show = get_theme_mod('smart_agency_mlogo_show', 1);
	$smart_agency_search_show = get_theme_mod('smart_agency_search_show', 1);
	$smart_agency_header_social_show = get_theme_mod('smart_agency_header_social_show');
	$smart_agency_hfacebook_link = get_theme_mod('smart_agency_hfacebook_link');
	$smart_agency_htwitter_link = get_theme_mod('smart_agency_htwitter_link');
	$smart_agency_hlinkedin_link = get_theme_mod('smart_agency_hlinkedin_link');
	$smart_agency_hyoutube_link = get_theme_mod('smart_agency_hyoutube_link');
	$smart_agency_hpinterest_link = get_theme_mod('smart_agency_hpinterest_link');
	$smart_agency_hinstagram_link = get_theme_mod('smart_agency_hinstagram_link');

	if ($smart_agency_search_show && $smart_agency_header_social_show) {
		$smart_agency_logo_col = '4';
		$smart_agency_search_col = '5';
		$smart_agency_social_col = '3';
	} elseif ($smart_agency_header_social_show) {
		$smart_agency_logo_col = '8';
		$smart_agency_search_col = ' ';
		$smart_agency_social_col = '4';
	} elseif ($smart_agency_search_show) {
		$smart_agency_logo_col = '7';
		$smart_agency_search_col = '5';
		$smart_agency_social_col = ' ';
	} else {
		$smart_agency_logo_col = '12';
		$smart_agency_search_col = ' ';
		$smart_agency_social_col = ' ';
	}

?>
	<div class="header-middle">
		<div class="container">
			<div class="header-middle-all-content">
				<div class="row">
					<div class="col-lg-<?php echo esc_attr($smart_agency_logo_col); ?>">
						<?php
						if ($smart_agency_mlogo_show) {
							smart_agency_logo_output();
						}
						?>
					</div>
					<?php if ($smart_agency_search_show) : ?>
						<div class="col-lg-<?php echo esc_attr($smart_agency_search_col); ?>">
							<div class="npaper search-box">
								<?php echo get_search_form(); ?>

							</div>
						</div>
					<?php endif; ?>
					<?php if ($smart_agency_header_social_show) : ?>
						<div class="col-lg-<?php echo esc_attr($smart_agency_social_col); ?>">
							<div class="header-links">
								<div class="social-links">
									<?php if ($smart_agency_hfacebook_link) : ?>
										<a href="<?php echo esc_url($smart_agency_hfacebook_link); ?>"><i class="fab fa-facebook-f"></i></a>
									<?php endif; ?>
									<?php if ($smart_agency_htwitter_link) : ?>
										<a href="<?php echo esc_url($smart_agency_htwitter_link); ?>"><i class="fab fa-twitter"></i></a>
									<?php endif; ?>
									<?php if ($smart_agency_hlinkedin_link) : ?>
										<a href="<?php echo esc_url($smart_agency_hlinkedin_link); ?>"><i class="fab fa-linkedin-in"></i></a>
									<?php endif; ?>
									<?php if ($smart_agency_hyoutube_link) : ?>
										<a href="<?php echo esc_url($smart_agency_hyoutube_link); ?>"><i class="fab fa-youtube"></i></a>
									<?php endif; ?>
									<?php if ($smart_agency_hpinterest_link) : ?>
										<a href="<?php echo esc_url($smart_agency_hpinterest_link); ?>"><i class="fab fa-pinterest"></i></a>
									<?php endif; ?>
									<?php if ($smart_agency_hinstagram_link) : ?>
										<a href="<?php echo esc_url($smart_agency_hinstagram_link); ?>"><i class="fab fa-instagram"></i></a>
									<?php endif; ?>
								</div>
							</div>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
<?php
}
add_action('smart_agency_header_logo', 'smart_agency_header_logo_output');

// Smart Agency mene style
function smart_agency_main_menu_output()
{
	$smart_agency_menubar_show = get_theme_mod('smart_agency_menubar_show', 1);
	if (empty($smart_agency_menubar_show)) {
		return;
	}

	$smart_agency_menubarlogo_show = get_theme_mod('smart_agency_menubarlogo_show', 1);
	$smart_agency_mainmenu_show = get_theme_mod('smart_agency_mainmenu_show', 1);
	$smart_agency_menusearch_show = get_theme_mod('smart_agency_menusearch_show', 1);

?>
	<div class="menu-bar ">
		<div class="container">
			<div class="menubar-content">
				<?php
				if ($smart_agency_menubarlogo_show) {
					smart_agency_logo_output();
				}
				?>
				<div class="smart-agency-container menu-inner">
					<?php if ($smart_agency_mainmenu_show) : ?>
						<nav id="site-navigation" class="main-navigation">
							<?php
							wp_nav_menu(array(
								'theme_location' => 'main-menu',
								'menu_id'        => 'smart-agency-menu',
								'menu_class'        => 'smart-agency-menu',
							));
							?>
						</nav><!-- #site-navigation -->
					<?php endif; ?>
					<?php if ($smart_agency_menusearch_show) : ?>
						<div class="serach-show">
							<div class="besearch-icon">
								<a href="#" id="besearch"><i class="fas fa-search"></i></a>
							</div>
							<div id="bspopup" class="soff">
								<div id="affsearch" class="sopen">
									<button data-widget="remove" id="removeClass" class="sclose" type="button">×</button>
									<?php get_search_form(); ?>
									<small class="beshop-cradit"><?php esc_html_e('Smart Agency Theme By', 'smart-agency') ?> <a target="_blank" title="<?php esc_attr_e('Smart Agency Theme', 'smart-agency') ?>" href="<?php echo esc_url('https://wpthemespace.com/product/beshop/'); ?>"><?php esc_html_e('Wp Theme Space', 'smart-agency') ?></a></small>
								</div>
							</div>
						</div>
				</div>
			<?php endif; ?>

			</div>

		</div>
	</div>

<?php
}
add_action('smart_agency_main_menu', 'smart_agency_main_menu_output');



// Smart Agency mene style
function smart_agency_mobile_menu_output()
{
?>
	<div id="wsm-menu" class="mobile-menu-bar wsm-menu">
		<div class="container">
			<nav id="mobile-navigation" class="mobile-navigation">
				<button id="mmenu-btn" class="menu-btn" aria-expanded="false">
					<span class="mopen"><?php esc_html_e('Menu', 'smart-agency'); ?></span>
					<span class="mclose"><?php esc_html_e('Close', 'smart-agency'); ?></span>
				</button>
				<?php
				wp_nav_menu(array(
					'theme_location' => 'main-menu',
					'menu_id'        => 'wsm-menu-ul',
					'menu_class'        => 'wsm-menu-has',
				));
				?>
			</nav><!-- #site-navigation -->
		</div>
	</div>

<?php
}
add_action('smart_agency_mobile_menu', 'smart_agency_mobile_menu_output');


function smart_agency_logo_output()
{
	$smart_agency_hide_tagline = get_theme_mod('smart_agency_hide_tagline');
?>
	<div class="head-logo-sec">
		<?php if (has_custom_logo()) : ?>
			<div class="site-branding brand-logo">
				<?php the_custom_logo(); ?>
			</div>
		<?php endif; ?>
		<?php
		if (display_header_text() == true || (display_header_text() == true && is_customize_preview())) : ?>
			<div class="site-branding brand-text">
			<?php if (display_header_text() == true || (display_header_text() == true && is_customize_preview())) : ?>
				<h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php echo esc_html(get_bloginfo('name', 'display')); ?></a></h1>
				<?php
				$smart_agency_description = get_bloginfo('description', 'display');
				if (($smart_agency_description || is_customize_preview()) && empty($smart_agency_hide_tagline)) :
				?>
					<p class="site-description"><?php echo esc_html($smart_agency_description); ?></p>
					<?php endif; ?>
				<?php endif; ?>

			</div><!-- .site-branding -->
		<?php endif; ?>
	</div>
<?php
}
