<?php
/*
 * Template Name: Left Sidebar
 *
 * @package SmallBusinessWide
 *
 */

get_header(); 

if (!get_theme_mod('page_imgonly','') || !is_front_page()) {?>

	<div id="primary" class="content-area">

		<div id="main" class="main">

			<?php do_action('smallbusinesswide_before_content'); ?>
			<div id="content" class="contentleft">

				<?php
				/* The Loop... */
				if (have_posts()) : 
					while (have_posts()) : the_post(); 
						get_template_part('templates/content','posts');
					endwhile; 
				
					//Pagination
					the_posts_pagination( array(
						'mid_size' => 2,
						'prev_text' => __( 'Previous', 'smallbusinesswide' ),
						'next_text' => __( 'Next', 'smallbusinesswide' ),
					) ); 
					
				//Nothing found: display message
				else : ?>
					<p><?php __('No result','smallbusinesswide'); ?></p>
				<?php endif; ?>

			</div>
			<?php do_action('smallbusinesswide_after_content'); ?>
		</div>
		<?php get_sidebar(); ?>
	</div>

	<div class="clear">
	</div>
<?php }?>

<!-- #footer -->
<?php get_footer(); ?>
