<?php 
/*
 * The main template file
 *
 * @package SmallBusinessWide
 *
 */
 
get_header(); 

/* Display the page content:
 *   - for the front page: the "Images only" checkbox is not checked
 *   - if we are not on the front page
 */
if (!get_theme_mod('page_imgonly','') || !is_front_page() ) { ?>

	<div id="primary" class="content-area">

		<div id="main" class="main">

			<div id="content" class="contentindex">

				<?php
				/* The Loop... */
				if (have_posts()) : 
					while (have_posts()) : the_post(); 
						get_template_part('templates/content','posts');
					endwhile; 
				
					//Pagination
					the_posts_pagination( array(
						'mid_size' => 2,
						'prev_text' => __( 'Previous', 'smallbusinesswide' ),
						'next_text' => __( 'Next', 'smallbusinesswide' ),
					) ); 
					
				//Nothing found: display message
				else : ?>
					<p><?php __('No result','smallbusinesswide'); ?></p>
				<?php endif; ?>

			</div>
			<?php get_sidebar(); ?>
		</div>
	</div>

	<div class="clear">
	</div>
<?php } ?>

<!-- #footer -->
<?php get_footer();?>
