<!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>" />
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
		<?php wp_head(); ?>
	</head>
	<body <?php body_class(); ?>>
		<div id="page" class="hfeed site">
			<?php if (get_theme_mod('page_imgonly','') && is_front_page() && !is_home() ) { ?>
			<div id="toppage" class="toppage">
				<div id="header">
					<div class="headersub" >
						<?php if (esc_url(get_background_image())!="") { ?> 
							<img id="header-fond-image" src="<?php echo esc_url(get_background_image()); ?>"  alt="<?php echo esc_attr_e('Header Background','smallbusinesswide') ?>" />
						<?php } ?>
						<?php if (esc_url(get_header_image())!="") { ?> 
							<img id="header-logo-image" src="<?php echo esc_url(get_header_image()); ?>" alt="<?php echo esc_attr_e('Header Logo','smallbusinesswide') ?>"/>
						<?php } ?>
					</div>
					<div id="header-title">
						<span><?php echo esc_html(get_theme_mod('bulle_title','')); ?></span>
					</div>
				</div>			
				<div id="headerbuttons" class="headbtn" >
					<?php						
						if (!empty(get_theme_mod('bulle_lien1','')[0]) && get_theme_mod('bulle_lien1','')[0]=="#" && !is_front_page())
							$bulle_lien1 = esc_url(home_url("","relative")."/".get_theme_mod('bulle_lien1',''));
						else
							$bulle_lien1 = esc_url(get_theme_mod('bulle_lien1',''));
						if (!empty(get_theme_mod('bulle_lien2','')[0]) && get_theme_mod('bulle_lien2','')[0]=="#" && !is_front_page())
							$bulle_lien2 = esc_url(home_url("","relative")."/".get_theme_mod('bulle_lien2',''));
						else
							$bulle_lien2 = esc_url(get_theme_mod('bulle_lien2',''));
						if (!empty(get_theme_mod('bulle_lien3','')[0]) && get_theme_mod('bulle_lien3','')[0]=="#" && !is_front_page())
							$bulle_lien3 = esc_url(home_url("","relative")."/".get_theme_mod('bulle_lien3',''));
						else
							$bulle_lien3 = esc_url(get_theme_mod('bulle_lien3',''));
						if ((get_theme_mod('bulle_texte1','').'')!=="" || $bulle_lien1!=="" ) {?>
							<div id="bul1" class="bubble bub1"><a href="<?php echo $bulle_lien1 ?>" onmousedown="bubClick('bul1');" onmouseup="bubPop('bul1');" onmouseout="bubPop('bul1');"><div class="clicbulle"><strong><?php echo esc_html(get_theme_mod('bulle_texte1','')) ?></strong></div></a></div>
						<?php } 
						if ((get_theme_mod('bulle_texte3','').'')!=="" || $bulle_lien3!=="" ) {?>
							<div id="bul3" class="bubble bub3"><a href="<?php echo $bulle_lien3 ?>" onmousedown="bubClick('bul3');" onmouseup="bubPop('bul3');" onmouseout="bubPop('bul3');"><div class="clicbulle"><strong><?php echo esc_html(get_theme_mod('bulle_texte3','')) ?></strong></div></a></div>
						<?php } 
						if ((get_theme_mod('bulle_texte2','').'')!=="" || $bulle_lien2!=="" ) {?>
							<div id="bul2" class="bubble bub2"><a href="<?php echo $bulle_lien2 ?>" onmousedown="bubClick('bul2');" onmouseup="bubPop('bul2');" onmouseout="bubPop('bul2');"><div class="clicbulle"><strong><?php echo esc_html(get_theme_mod('bulle_texte2','')) ?></strong></div></a></div>  
						<?php } 
					?>
				</div>
				<div class="clear">&nbsp;</div>
			</div>
			<?php } 
			if (!get_theme_mod('page_imgonly','') || !is_front_page() ) { ?>
				<div id="headpage" class="headpage">
					<?php if ( function_exists( 'the_custom_logo' ) ) {
						the_custom_logo();
					} else {
						if (get_theme_mod('page_logo','')!='') {?>
							<a href="<?php echo esc_url( home_url() ) ?>"><img src="<?php echo esc_url(get_theme_mod('page_logo','')) ?>" alt="<?php echo esc_attr(__('Company Logo','smallbusinesswide')) ?>" ></a>
						<?php } else { ?>
							<a href="<?php echo esc_url( home_url() ) ?>"><div class="mainlogo" ><?php echo __('Company Logo','smallbusinesswide') ?></div></a>
						<?php } 
					} ?>
					<span class="spanhead"><?php echo esc_html( get_bloginfo( 'name', 'display' ) ); ?></span>
				</div>

				<div id="nav" class="headernav">
					<?php
						$defaults = array(
							'theme_location'  => 'main-nav',
							'menu_class'      => '',
							'menu_id'         => '',
							'echo'            => true,
							'fallback_cb'     => 'wp_page_menu',
							'before'          => '',
							'after'           => '',
							'link_before'     => '',
							'link_after'      => '',
							'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
							'depth'           => 0,
							'walker'          => ''
						);

						wp_nav_menu( $defaults );
					?>
				</div>
			<?php } ?>