<?php

/*
 * Theme setup
 */
if ( ! function_exists( 'smallbusinesswide_setup' ) ) :
function smallbusinesswide_setup() {
	load_theme_textdomain('smallbusinesswide',get_template_directory().'/languages');
	$defaults = array(
		'default-image'          => '',
		'width'                  => 1920,
		'height'                 => 1106,
		'flex-height'            => false,
		'flex-width'             => false,
		'uploads'                => true,
		'random-default'         => false,
		'header-text'            => false,
		'default-text-color'     => '000000',
		'wp-head-callback'       => '',
		'admin-head-callback'    => '',
		'admin-preview-callback' => '',
	);
	add_theme_support( 'custom-header', $defaults );
	$defaults = array(
		'default-color'          => 'FFFFFF',
		'default-image'          => '',
		'wp-head-callback'       => '_custom_background_cb',
		'admin-head-callback'    => '',
		'admin-preview-callback' => ''
	);
	add_theme_support( 'custom-background', $defaults );
	add_theme_support( 'post-thumbnails' ); 
	register_nav_menus(
		array(
			'main-nav'   => __( 'Main Navigation', 'smallbusinesswide' ),
			'footer-nav' => __( 'Footer Navigation', 'smallbusinesswide' )
		)
	);
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	add_theme_support( "post-thumbnails" );

	/* Custom logo support */
    add_theme_support( 'custom-logo', array(
		   'height'      => 165,
		   'width'       => 330,
		   'flex-width' => true,
		) 
	);

	/*
	 * Theme default width
	 */
	if ( ! isset( $content_width ) ) {
		$content_width = 920;
	}
}
add_action( 'after_setup_theme', 'smallbusinesswide_setup' );
endif;

/*
 * Theme global scripts and theme
 */
if ( ! function_exists( 'smallbusinesswide_enqueue_scripts' ) ) :
function smallbusinesswide_enqueue_scripts() {
    wp_enqueue_style( 'smallbusinesswide-style', get_stylesheet_uri() );
	if (esc_url_raw(get_background_image())=="")
		$bgpos = "";
	else
		$bgpos = "position: absolute;";
	$css='';
	$css .= 'div.bubble a:link, div.bubble a:visited { color:' . esc_html(get_theme_mod('bulle_textcolor','#8888AA')) . ';} ';
	$css .= '.toppage {background-color:#' . esc_html(get_background_color()) . ';} ';
	$css .= '.headpage {background-color:#' . esc_html(get_background_color()) . ';} ';
	$css .= '#header-title {color: #' . esc_html(get_header_textcolor()) . ';} ';
	$css .= '#header-logo-image {' . $bgpos . ';} ';
	$css .= '.bubble {background: url("' . esc_url(get_theme_mod('bulle_bg','')) .'") no-repeat;}';
	$css .= '.content-area { background: url("' . esc_html(get_theme_mod('page_bg','')) . '")}';
	$css .= '.main { background-color:#' . esc_html(get_background_color()) . ';}';
	$css .= '.spanhead {color: #';
	if (get_header_textcolor()=="") {
		$css .= "000000";
	} else {
		$css .= esc_html(get_header_textcolor());
	}
	$css .= ';}';
	$css .= '.contentindex, .contentsingle, .contentleft, .contentno, .contentright { background-color:#' . esc_html(get_background_color()). ';}';
	
	wp_add_inline_style( 'smallbusinesswide-style', $css );
	
}
add_action('wp_enqueue_scripts','smallbusinesswide_enqueue_scripts');
endif;

/*
 * Theme Widget registration
 */
if ( ! function_exists( 'smallbusinesswide_widgets_init' ) ) :
function smallbusinesswide_widgets_init() {

	register_sidebar( array(
		'name' => __( 'Widgets', 'smallbusinesswide' ),
		'id' => 'sidebar-1',
		'description' => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
}
add_action( 'widgets_init', 'smallbusinesswide_widgets_init' );
endif;

/*
 * Theme customizations in Admin
 *
 * Sanitize checkboxes
 */
if ( ! function_exists( 'smallbusinesswide_sanitize_checkbox' ) ) :
function smallbusinesswide_sanitize_checkbox( $checked ) {
// return boolean value
	return ( ( isset( $checked ) && true == $checked ) ? true : false );
}
endif;
/*
 *    Home page and header images
 *    Bubble images/actions
 */
if ( ! function_exists( 'smallbusinesswide_customize_register' ) ) :
function smallbusinesswide_customize_register( $wp_customize ) {
   //section pour les bulles
	$wp_customize->add_section( 'smallbusinesswide_bulles' , array(
		'title'      => __( 'Bubbles', 'smallbusinesswide' ),
		'priority'   => 30,
		'description' => __('Header must be added for bubbles','smallbusinesswide')
	) );
	$wp_customize->add_setting( 'bulle_texte1', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field'
	) );
	$wp_customize->add_control('bulle_texte1', array(
		'label'        => __( 'Text for the left bubble', 'smallbusinesswide' ),
		'section' => 'smallbusinesswide_bulles',
		'settings'   => 'bulle_texte1'
	) );
	$wp_customize->add_setting( 'bulle_lien1', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'sanitize_callback' => 'esc_url_raw'
	) );
	$wp_customize->add_control('bulle_lien1', array(
		'label'        => __( 'Hyperlink for the left bubble', 'smallbusinesswide' ),
		'section' => 'smallbusinesswide_bulles',
		'settings'   => 'bulle_lien1',
	) );
	$wp_customize->add_setting( 'bulle_texte2', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field'
	) );
	$wp_customize->add_control('bulle_texte2', array(
		'label'        => __( 'Text for the central bubble', 'smallbusinesswide' ),
		'section' => 'smallbusinesswide_bulles',
		'settings'   => 'bulle_texte2',
	) );
	$wp_customize->add_setting( 'bulle_lien2', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'sanitize_callback' => 'esc_url_raw'
	) );
	$wp_customize->add_control('bulle_lien2', array(
		'label'        => __( 'Hyperlink for the central bubble', 'smallbusinesswide' ),
		'section' => 'smallbusinesswide_bulles',
		'settings'   => 'bulle_lien2',
	) );
	$wp_customize->add_setting( 'bulle_texte3', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field'
	) );
	$wp_customize->add_control('bulle_texte3', array(
		'label'        => __( 'Text for the right bubble', 'smallbusinesswide' ),
		'section' => 'smallbusinesswide_bulles',
		'settings'   => 'bulle_texte3',
	) );
	$wp_customize->add_setting( 'bulle_lien3', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'sanitize_callback' => 'esc_url_raw'
	) );
	$wp_customize->add_control('bulle_lien3', array(
		'label'        => __( 'Hyperlink for the right bubble', 'smallbusinesswide' ),
		'section' => 'smallbusinesswide_bulles',
		'settings'   => 'bulle_lien3',
	) );
	$wp_customize->add_setting( 'bulle_textcolor' , array(
		'default'     => '#000000',
		'transport'   => 'refresh',
		'sanitize_callback' => 'sanitize_hex_color'
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'link_color', array(
		'label'        => __( 'Text color', 'smallbusinesswide' ),
		'section'    => 'smallbusinesswide_bulles',
		'settings'   => 'bulle_textcolor',
	) ) );
	$wp_customize->add_setting( 'bulle_title', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_text_field'
	) );
	$wp_customize->add_control('bulle_title', array(
		'label'        => __( 'Title in bubbles page', 'smallbusinesswide' ),
		'section' => 'smallbusinesswide_bulles',
		'settings'   => 'bulle_title',
	) );
	$wp_customize->add_setting( 'bulle_bg', array(
		'transport'   => 'refresh',
		'capability'  => 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'bulle_bg', array(
		'label'   => __( 'Bubble image', 'smallbusinesswide' ),
		'section' => 'smallbusinesswide_bulles',
		'settings'   => 'bulle_bg',
	) ) );
	$wp_customize->add_setting( 'bulle_bgdn', array(
		'transport'   => 'refresh',
		'capability'  => 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'bulle_bgdn', array(
		'label'   => __( 'Pressed bubble image', 'smallbusinesswide' ),
		'section' => 'smallbusinesswide_bulles',
		'settings'   => 'bulle_bgdn',
	) ) ); 
    //Header logo, background for pages 
	$wp_customize->add_section( 'smallbusinesswide_pages' , array(
		'title'      => __( 'Pages', 'smallbusinesswide' ),
		'priority'   => 30,
	) );
	global $wp_version;
	if ( $wp_version < 4.5 ) {
		$wp_customize->add_setting( 'page_logo', array(
			'transport'   => 'refresh',
			'capability'  => 'edit_theme_options',
			'sanitize_callback' => 'esc_url_raw'
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'page_logo', array(
			'label'   => __( 'Header logo', 'smallbusinesswide' ),
			'section' => 'smallbusinesswide_pages',
			'settings'   => 'page_logo',
		) ) ); 
	}
	$wp_customize->add_setting( 'page_bg', array(
		'transport'   => 'refresh',
		'capability'  => 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'page_bg', array(
		'label'   => __( 'Background image', 'smallbusinesswide' ),
		'section' => 'smallbusinesswide_pages',
		'settings'   => 'page_bg',
	) ) ); 
    $wp_customize->add_setting( 'page_imgonly', array(
        'default'       => false,
        'capability' => 'edit_theme_options',
		'sanitize_callback' => 'smallbusinesswide_sanitize_checkbox'
    ) );
    $wp_customize->add_control( 'page_imgonly', array(
        'label'      => __( 'Start page with images only', 'smallbusinesswide' ),
        'section'    => 'smallbusinesswide_pages',
        'settings'   => 'page_imgonly',
        'type'       => 'checkbox',
        'std'         => '0'
    ) );   
	$wp_customize->get_setting( 'background_color' )->transport = 'postMessage';
}
add_action( 'customize_register', 'smallbusinesswide_customize_register' );
endif;

/*
 * Comments replies
 */
if ( ! function_exists( 'smallbusinesswide_enqueue_comment_reply' ) ) :
function smallbusinesswide_enqueue_comment_reply() {
	
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) { 
        wp_enqueue_script( 'comment-reply' ); 
    }
}
add_action( 'wp_enqueue_scripts', 'smallbusinesswide_enqueue_comment_reply' );
endif;

/*
 * Theme live preview in admin
 */
if ( ! function_exists( 'smallbusinesswide_live_preview' ) ) :
function smallbusinesswide_live_preview()
{
	wp_enqueue_script( 
		  'smallbusinesswide_themecustomizer',			
		  get_template_directory_uri().'/js/customizer.js',
		  array( 'jquery','customize-preview' ),	
		  '',						
		  true		
	);
}
add_action( 'customize_preview_init', 'smallbusinesswide_live_preview' );
endif;
 
/*
 * Custom dynamic javascript
 */
if ( ! function_exists( 'smallbusinesswide_scripts' ) ) :
function smallbusinesswide_scripts() {
	wp_enqueue_script('smallbusinesswide_script',
		get_template_directory_uri().'/js/smallbusinesswide.js',
		array('jquery'),	
		'',						
		true
	);
	$smallbusinesswide_parm = array(
		'testHome' => (is_home() || is_front_page()),
		'imgBulle' => esc_html(get_theme_mod('bulle_bg','')),
		'imgBulleBas' => esc_html(get_theme_mod('bulle_bgdn',''))
	);
	wp_localize_script('smallbusinesswide_script','smallbusinesswide_parm',$smallbusinesswide_parm);
}
add_action( 'wp_enqueue_scripts', 'smallbusinesswide_scripts' );
endif;