<?php 
/*
 * The archives template file
 *
 * @package SmallBusinessWide
 *
 */
 
get_header(); 

/* Display the page content:
 *   - for the front page: the "Images only" checkbox is not checked
 *   - if we are not on the front page
 */
if (!get_theme_mod('page_imgonly','') || !is_front_page() ) { ?>

	<div id="primary" class="content-area">

		<div id="main" class="main">

			<div id="content" class="contentindex">
				<?php 
					echo "<h2>" . get_the_title() . "</h2>";
					echo "<h3>";
					echo __('Archives','smallbusinesswide') . "<h3>";

					$args = array(
						'post_type' => 'post', 
						'posts_per_page'=> -1
					);
					$archposts = new WP_Query( $args );
					
					$date_old = "";
					$ul_open = false;
					while ( $archposts->have_posts() ) : $archposts->the_post();
						$date_new = get_the_time("F Y");
						if ( $date_old != $date_new ) :  
							if($ul_open == true) : ?>
								</ul>
							<?php endif; ?>
							<h4><?php echo $date_new; ?></h4>
							<ul>
							<?php $ul_open = true; ?>
						<?php endif; ?>
						<li><span><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></span></li>
						<?php $date_old = $date_new; 
					endwhile; 
					wp_reset_postdata();  
				?>
				</ul>  
			</div>
			<?php get_sidebar(); ?>
		</div>
	</div>
	<div class="clear">
	</div>
<?php } ?>

<!-- #footer -->
<?php get_footer();?>
