<?php
/**
* Theme functions used by SLS.
*
* Authors: wpart
* Copyright: 2012
* {@link http://wpart.org/}
*
* Released under the terms of the GNU General Public License.
* You should have received a copy of the GNU General Public License,
* along with this software. In the main directory, see: /licensing/
* If not, see: {@link http://www.gnu.org/licenses/}.
*
* @package SLS.
* @since 1.5
*/

 ?>

<?php

function SLS_widgets_init() {   
	register_sidebar(array(
	    'id' => 'sidebar',
		'name' =>  'sidebar',
		'before_widget' => '<li id="%1$s" class="side widget %2$s">', 
		'after_widget' => '</li>',
		'before_title' => '<h3 class="title3">', 
		'after_title' => '</h3>' 
	));
 
}

add_action( 'widgets_init', 'SLS_widgets_init');

if ( ! isset( $content_width ) )
	$content_width = 665;

function SLS_setup() {


	add_custom_background();

	add_editor_style();


	add_theme_support( 'post-thumbnails' ); 
	
	set_post_thumbnail_size( 284, 90, true );

	add_theme_support( 'automatic-feed-links' );
	
		register_nav_menus( array(
		'primary' =>'Primary Menu',
	) );		
			
			
	add_theme_support( 'post-formats', array( 'aside', 'link', 'gallery', 'status', 'quote', 'image' ) );
			


	
	
	
	defined( 'HEADER_IMAGE' );
	define( 'HEADER_IMAGE', '%s/images/header.jpg' );

	define( 'HEADER_IMAGE_WIDTH', apply_filters( 'SLS_header_image_width', 940 ) );
	define( 'HEADER_IMAGE_HEIGHT', apply_filters( 'SLS_header_image_height', 188 ) );

	
	define( 'NO_HEADER_TEXT', true );


	add_custom_image_header( 'SLS_header_style', 'SLS_admin_header_style' );
	
	function SLS_header_style() {
				?>
<style type="text/css">
#headimg {
}
</style>
<?php
			}
	
	
function SLS_admin_header_style() { ?>
<style type="text/css">
#headimg {
 height: <?php echo HEADER_IMAGE_HEIGHT;
?>px;
 width: <?php echo HEADER_IMAGE_WIDTH;
?>px;
}
#headimg h1, #headimg #desc {
	display: none;
}
</style>
<?php }
			
			
			
			
}
add_action( 'after_setup_theme', 'SLS_setup' );


function SLS_excerpt_length( $length ) {
	return 20;
}
add_filter( 'excerpt_length', 'SLS_excerpt_length', 999 );

function SLS_scripts(){
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );
  }
  add_action( 'wp_enqueue_scripts', 'SLS_scripts' );

?>
