<?php
/**
* Archive template used by SLS.
*
* Authors: wpart
* Copyright: 2012
* {@link http://wpart.org/}
*
* Released under the terms of the GNU General Public License.
* You should have received a copy of the GNU General Public License,
* along with this software. In the main directory, see: /licensing/
* If not, see: {@link http://www.gnu.org/licenses/}.
*
* @package SLS.
* @since 1.5
*/

get_header(); ?>

<div id="left">
  <?php if (have_posts()) : ?>
			<h1 class="pagetitle">
<?php if ( is_day() ) : ?>
				<?php printf(  'Daily Archives: <span>%s</span>', get_the_date() ); ?>
<?php elseif ( is_month() ) : ?>
				<?php printf( 'Monthly Archives: <span>%s</span>', get_the_date('F Y') ); ?>
<?php elseif ( is_year() ) : ?>
				<?php printf(  'Yearly Archives: <span>%s</span>', get_the_date('Y') ); ?>
 <?php elseif ( is_author() ) : ?>
				<?php printf( 'Author Archive'); ?>
 <?php elseif ( is_category() ) : ?>
				<?php printf( 'Category Archive: <span>%s</span>',single_cat_title("", false)); ?>
 <?php elseif ( is_tag() ) : ?>
				<?php printf( 'Tag Archive: <span>%s</span>',single_tag_title("", false)); ?>
<?php else : ?>
				Blog Archives
<?php endif; ?>
			</h1>
  <?php while (have_posts()) : the_post(); ?>
  <div class="post" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="fl">
      <h1 class="title">
        <?php the_title(); ?>
      </h1>
      <div class="postinfo"> BY
        <?php the_author_posts_link(); ?>
        |
        <?php the_time('F jS, Y') ?>
      </div>
    </div>
    <div class="fr">
<?php comments_popup_link('No Comments &#187;','1 Comment &#187;','% Comments &#187;', '','Comments Closed' ); ?>
    </div>
    <div class="cb"></div>
    <div class="entry">
      <?php the_content('Read the rest of this entry &raquo;'); ?>
    </div>
    <div class="tags">
      Category:
        <?php the_category(', '); ?>

        <?php the_tags('TAG:', ' , ' , ''); ?>
      <?php edit_post_link('Edit ', '', ''); ?>
    </div>
  </div>
  <?php endwhile;?>
  <?php comments_template(); ?>
  <?php else : ?>
  <?php endif; ?>
</div>
<!-- /content -->
<?php get_sidebar(); ?>
<?php get_footer(); ?>
