<?php
/**
 * Front Workingstep Section
 *
 * @package constructionn
 */
$toggle_front_workingstep = get_theme_mod( 'toggle_front_workingstep', false );
$workstep_headings        = get_theme_mod( 'workstep_headings' );
$front_workstep_repeaters = get_theme_mod( 'front_workstep_repeaters', array() );

if ( $toggle_front_workingstep && ( $workstep_headings || $front_workstep_repeaters ) ) { ?>
	<div id="front-workingstep" class="process-section front-workingstep">
		<div class="container">
			<div class="row">
				<div class="services-wrap">
					<div class="process-wrapper">
						<?php if ( $workstep_headings ) { ?>
								<div class="section-meta-wrap">
									<h2 class="section-heading"><?php echo esc_html( $workstep_headings ); ?></h2>
								</div>
						<?php } ?>
					<?php
					foreach ( $front_workstep_repeaters as $repeater ) {
						$text        = ( ! empty( $repeater['text'] ) && isset( $repeater['text'] ) ) ? $repeater['text'] : '';
						$description = ( ! empty( $repeater['description'] ) && isset( $repeater['description'] ) ) ? $repeater['description'] : '';
						$image       = ( ! empty( $repeater['image'] ) && isset( $repeater['image'] ) ) ? $repeater['image'] : '';

						if ( $text || $description || $image ) {
							?>
							<div class="process__card">
								<?php if ( $image ) { ?>
									<div class="feature-image">
										<?php echo wp_get_attachment_image( $image, 'thumbnail', true ); ?>
									</div>
								<?php } if ( $text ) { ?>
									<h5 class="title"><?php echo esc_html( $text ); ?></h5>
								<?php } if ( $description ) { ?>
									<p class="desc">
										<?php echo esc_html( $description ); ?>
									</p>
									<?php
								}
								?>
							</div>   
							<?php
						}
					}
					?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
} 