<?php
/**
 * Front Testimonial Section
 *
 * @package constructionn
 */

$testimonials_headings          = get_theme_mod( 'testimonial_heading' );
$testimony_description          = get_theme_mod( 'testimony_description' );
$testimonial_author             = get_theme_mod( 'testimonial_author' );
$testimonial_author_designation = get_theme_mod( 'testimonial_author_designation' );
$testimonial_author_img         = get_theme_mod( 'testimonial_author_img' );
$testimonial_image_id           = attachment_url_to_postid( $testimonial_author_img );

if ( $testimonials_headings || $testimony_description || $testimonial_author || $testimonial_author_designation || $testimonial_image_id ) { ?>
	<div class="testimonial-section sec-testimon" id="front-testimonial">
		<div class="container">
			<?php if ( $testimonials_headings ) { ?>
				<div class="section-meta-wrap is-centered">
					<h2 class="section-heading">
						<?php echo esc_html( $testimonials_headings ); ?>	
					</h2>
				</div>
			<?php } if ( $testimony_description || $testimonial_author || $testimonial_author_designation || $testimonial_image_id ) { ?>
				<div class="testimonial-swiper">
					<div class="swiper-wrapper">
						<div class="swiper-slide">
							<div class="client-review testimonial-card">
								<div class="testimonial-content">
									<div class="author-image-wrapper">
										<?php if ( $testimonial_image_id ) { ?>
											<div class="author-image">
												<?php echo wp_get_attachment_image( $testimonial_image_id, 'testimonial_image' ); ?>
											</div>
										<?php } ?>
									</div>
									<div class="testimonial-text-wrapper">
										<div class="quote-marks">"</div>
										<?php if ( $testimony_description ) { ?>
											<div class="message-wrapper">
												<?php echo wp_kses_post( $testimony_description ); ?>
											</div>
										<?php } ?>
										<div class="review-author">
											<span class="author-details">
												<?php if ( $testimonial_author || $testimonial_author_designation ) { ?>
													<span class="details-wrapper">
														<?php if ( $testimonial_author ) { ?>
															<span class="author-name">
																<span class="byline">
																	<span>
																		<a><?php echo esc_html( $testimonial_author ); ?></a>
																	</span>
																</span>
															</span>
														<?php } if ( $testimonial_author_designation ) { ?>
															<span class="author-signature">
																<span class="byline">
																	<span>
																		<a><?php echo esc_html( $testimonial_author_designation ); ?></a>
																	</span>
																</span>
															</span>
														<?php } ?>
													</span>
												<?php } ?>
											</span>
										</div>
									</div>
								</div>
								<div class="decorative-element"></div>
							</div>
						</div>
					</div>
				</div>
				<?php
			}
			?>
		</div>
	</div>
	<?php
} 