<?php
/**
 * Front Counter Section
 *
 * @package constructionn-child
 */
$toggle_front_counter          = get_theme_mod( 'toggle_front_counter', false );
$counter_headings              = get_theme_mod( 'counter_headings' );
$front_counter_repeaters       = get_theme_mod( 'front_counter_repeaters' );
$front_count_feature_repeaters = get_theme_mod( 'front_count_feature_repeaters' );

if ( $toggle_front_counter ) { ?>
	<div id="front-counter" class="counter-section front-counter">
		<div class="container">
			<div class="counter-wrapper">
				<div class="counter-top">
					<div class="counter-title">
						<?php if ( $counter_headings ) { ?>
							<div class="section-meta-wrap">
								<h2 class="section-heading"><?php echo esc_html( $counter_headings ); ?></h2>
							</div>
							<?php
						} ?>
					</div>
					<?php
						if ( $front_counter_repeaters ) {
							echo '<div class="counter-right">';
							foreach ( $front_counter_repeaters as $numrepeater ) {
								$counter_title  = ( ! empty( $numrepeater['title'] ) && isset( $numrepeater['title'] ) ) ? $numrepeater['title'] : '';
								$counter_count  = ( ! empty( $numrepeater['counter'] ) && isset( $numrepeater['counter'] ) ) ? $numrepeater['counter'] : '';
								$counter_prefix = ( ! empty( $numrepeater['prefix'] ) && isset( $numrepeater['prefix'] ) ) ? $numrepeater['prefix'] : '';
	
								if ( $counter_title || ( $counter_count && $counter_prefix ) ) {
									?>
									<?php if ( $counter_title || ( $counter_count && $counter_prefix ) ) { ?>
										<div class="counter-card">
											<?php if ( $counter_count && $counter_prefix ) { ?>
												<span class="counter-number" data-count="<?php echo esc_attr( $counter_count ); ?>" data-prefix="<?php echo esc_attr( $counter_prefix ); ?>">
													<?php echo esc_html( $counter_count . $counter_prefix ); ?>
												</span>
											<?php } if ( $counter_title ) { ?>
												<span class="counter-label"><?php echo esc_html( $counter_title ); ?></span>
											<?php } ?>
										</div>
									<?php } ?>                                   
									<?php
								}
							}
							echo '</div>';
						}
					?>
				</div>
				<?php
					if( $front_count_feature_repeaters ) {
						echo '<div class="counter-bottom">';
						foreach ( $front_count_feature_repeaters as $countrepeater ) {
							$text        = ( ! empty( $countrepeater['text'] ) && isset( $countrepeater['text'] ) ) ? $countrepeater['text'] : '';
							$description = ( ! empty( $countrepeater['description'] ) && isset( $countrepeater['description'] ) ) ? $countrepeater['description'] : '';

							if ( $text || $description ) {
								?>
								<div class="about-mvc">
									<?php if ( $text ) { ?>
										<h4 class="title"><?php echo esc_html( $text ); ?></h4>
									<?php } if ( $description ) { ?>
										<p class="desc"><?php echo esc_html( $description ); ?></p>
										<?php
									}
									?>
								</div>                              
								<?php
							}
						}
					}
					echo '</div>';
				?>
			</div>
		</div>
	</div>
	<?php
} 