<?php
/**
 * Front Contact Section
 *
 * @package constructionn
 */
$toggle_contact         = get_theme_mod( 'toggle_front_contact', false );
$contact_headings       = get_theme_mod( 'contact_headings' );
$contact_descriptions   = get_theme_mod( 'contact_descriptions' );
$contact_form_shortcode = get_theme_mod( 'fcontact_form_shortcode' );
$contact_info_heading   = get_theme_mod( 'contact_info_heading' );
$contact_extra_info     = get_theme_mod( 'contact_extra_info' );
$contact_phone_label    = get_theme_mod( 'contact_phone_label' );
$contact_phone_number   = get_theme_mod( 'contact_phone_number' );

if ( $toggle_contact && ( $contact_headings || $contact_descriptions || $contact_form_shortcode  || $contact_info_heading || $contact_extra_info || $contact_phone_label || $contact_phone_number) ) { ?>
	<div id="front-contact" class="contact-section front-contact">
		<div class="container">
			<div class="row">
				<div class="col-lg-8">
					<?php if ( $contact_headings || $contact_descriptions ) { ?>
						<div class="section-meta-wrap">
							<?php if ( $contact_headings ) { ?>
								<h2 class="section-heading"><?php echo esc_html( $contact_headings ); ?></h2>
							<?php } if ( $contact_descriptions ) { ?>
								<p class="section-desc left-description"><?php echo esc_html( $contact_descriptions ); ?></p>
							<?php } ?>
						</div>
						<?php
					}
					?>
					<?php if ( $contact_form_shortcode ) { ?>
						<div class="contact-form-wrapper">
							<?php echo do_shortcode( $contact_form_shortcode ); ?>
						</div>
					<?php } ?>	
				</div>
				<?php
				if ( ( $contact_info_heading || $contact_extra_info || $contact_phone_label || $contact_phone_number) ) { ?>		
						<div class="col-lg-4">
							<div class="contact-info-box bg-black">
								<?php 	if ( ( $contact_info_heading || $contact_extra_info ) ) { ?>
									<div class="section-card-wrap">
										<h4 class="section-heading"><?php echo esc_html( $contact_info_heading ); ?></h4>
										<p class="section-desc right-extra-info"><?php echo esc_html( $contact_extra_info ); ?></p>
									</div>
								<?php }?>	
								<?php if ( ( $contact_phone_label || $contact_phone_number) ) { ?>
									<div class="contact-phone">
										<span class="phone-icon"><?php echo ( constructionn_handle_all_svgs('contact-ph'));?></span>
										<span class="phone-text"><?php echo esc_html( $contact_phone_label ); ?></span>
										<span class="phone-number"><?php echo esc_html( $contact_phone_number ); ?></span>
									</div>
								<?php }?>	
							</div>
							<div class="social-wrap">
								<?php constructionn_social_media_repeater( 'contact-section-social-media' ); ?>
							</div>
						</div>
				<?php } ?>		
			</div>
		</div>
	</div>
	<?php
} 