<?php
/**
 * Front Blog Section
 *
 * @package constructionn
 */

$toggle_front_blog  = get_theme_mod( 'toggle_front_blog', true );
$front_blog_heading = get_theme_mod( 'front_blog_heading', __( 'We provide solution to every queries!', 'skyline-construction' ) );
$args = array(
	'ignore_sticky_posts' => true,
	'posts_per_page'      => 2,
);
$blog_posts = new WP_Query( $args );

if ( $toggle_front_blog && ( $front_blog_heading || $blog_posts->have_posts() ) ) { ?>
	<div class="blog-section" id="front-blog">
		<div class="container">
			<?php if ( $front_blog_heading ) { ?>
				<div class="section-meta-wrap">
					<h2 class="section-heading"><?php echo esc_html( $front_blog_heading ); ?></h2>
				</div>
			<?php }  if ( $blog_posts->have_posts() ) { ?>
				<div class="blog-wrapper">
					<div class="blogs-swiper">
						<div class="swiper-wrapper">
							<?php
							while ( $blog_posts->have_posts() ) {
								$blog_posts->the_post();
								?>
								<div class="swiper-slide">
									<article class="post">
										<div class="blog__card">
											<figure class="blog__img">
												<a href="<?php the_permalink(); ?>">
													<?php
													if ( has_post_thumbnail() ) {
														the_post_thumbnail( 'blog_card_img' );
													} else {
														constructionn_get_fallback_svg( 'blog_card_img' );
													}
													?>
												</a>
												<div class="blog_meta_wrap">
													<?php
														constructionn_posted_on(); 
														constructionn_category(); 
													?>
												</div>
											</figure>
											<div class="blog__info">
												<a href="<?php the_permalink(); ?>">
												<?php the_title(); ?>
												</a>
											</div>
										</div>
									</article>
								</div>
							<?php } ?>
						</div>
					</div>
				</div>
			<?php } wp_reset_postdata(); ?>
		</div>
	</div>
	<?php
} 