<?php
/**
 * Front Banner Section
 *
 * @package constructionn
 */

$banner_toggle        = get_theme_mod( 'banner_toggle', true );
$s_banner_heading     = get_theme_mod( 'ban_three_heading', __( 'BUILDING THE', 'skyline-construction' ) ); 			
$s_banner_subheading  = get_theme_mod( 'ban_three_subheading', __( 'EXCELLENCE', 'skyline-construction' ) );
$s_banner_desc        = get_theme_mod( 'ban_three_descs', __( 'We Don\'t Just Build Structures; We Build Relationships Grounded In Quality, Reliability, And Unparalleled Expertise.', 'skyline-construction' ) );
$s_banner_btn         = get_theme_mod( 'b_three_btn_txt_one', __( 'Learn More', 'skyline-construction' ) );
$s_banner_btn_link    = get_theme_mod( 'b_three_btn_link_one', '#' );

if ( $banner_toggle && ( $s_banner_heading || $s_banner_subheading || $s_banner_desc || ( $s_banner_btn && $s_banner_btn_link ) ) ) { ?>
	<section id="banner-section" class="banner-section">
		<div class="container"> 
		<div class="banner__content">	
			<?php if ( $s_banner_heading || $s_banner_subheading || $s_banner_desc || ( $s_banner_btn && $s_banner_btn_link ) ) { ?>
					<div class="banner-text-wrapper">
						<?php if ( $s_banner_heading || $s_banner_subheading ) { ?>
							<div class="banner-text-left">
								<div class="banner__title-wrapper">
								<?php if ( $s_banner_heading ) { ?>
										<h2 class="banner__main-title">
											<?php echo esc_html( $s_banner_heading ); ?>
											<?php if ( $s_banner_subheading ) { ?>
											<span class="banner__subtitle"><?php echo esc_html( $s_banner_subheading ); ?></span>
											<?php } ?>
										</h2>
									<?php } ?>
								</div>
							</div>
						<?php } ?>
						<div class="banner-text-right">	
							<?php if ( $s_banner_desc ) { ?>
								<div class="banner__description-wrapper">
									<p class="banner__description"><?php echo esc_html( $s_banner_desc ); ?></p>
								</div>
							<?php } ?>
							<?php if ( $s_banner_btn && $s_banner_btn_link ) { ?>
								<div class="banner__button-wrapper">
									<a href="<?php echo esc_url( $s_banner_btn_link ); ?>" class="btn btn-primary">
										<span class="btn-text"><?php echo esc_html( $s_banner_btn ); ?></span>
										<span class="btn-icon">
											<svg width="23" height="24" viewBox="0 0 23 24" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M8.59168 7.86346C8.55925 7.89589 8.53332 7.93434 8.51572 7.9767C8.49813 8.01919 8.48879 8.06538 8.48879 8.11136C8.48885 8.15715 8.49821 8.20232 8.51572 8.24463C8.5333 8.28707 8.55852 8.32608 8.59099 8.35857C8.62347 8.39105 8.6625 8.41624 8.70493 8.43384C8.74741 8.45143 8.79291 8.46146 8.83889 8.46146H14.3576L7.17747 15.6416C7.11183 15.7073 7.07458 15.7967 7.07458 15.8895C7.0747 15.9822 7.11131 16.0712 7.17678 16.1367C7.24242 16.2024 7.33185 16.2396 7.42468 16.2396C7.51749 16.2396 7.60695 16.2024 7.67258 16.1367L14.8528 8.95657V14.4753C14.8529 14.568 14.8895 14.657 14.955 14.7225C15.0206 14.7882 15.11 14.8254 15.2029 14.8254C15.2957 14.8254 15.3851 14.7882 15.4508 14.7225C15.5162 14.657 15.5528 14.568 15.553 14.4753V8.11136C15.553 8.06536 15.5436 8.0192 15.526 7.9767C15.5084 7.93432 15.4825 7.89591 15.4501 7.86346C15.4176 7.83099 15.3793 7.80507 15.3368 7.7875C15.2943 7.76992 15.2488 7.76124 15.2029 7.76126H8.83889C8.79292 7.76126 8.7474 7.76991 8.70493 7.7875C8.66251 7.80507 8.62417 7.83101 8.59168 7.86346Z" fill="White" stroke="#F96900" stroke-width="0.2"/>
											</svg>
										</span>
									</a>
								</div>
							<?php } ?>
						</div>	
					</div>
			<?php } ?>				
		</div>
		</div>
		<div class="banner-background">
			<?php the_custom_header_markup(); ?>
		</div>
	</section>
<?php } ?> 