<?php
/**
 * Front About Section
 *
 * @package constructionn
 */
$toggle_front_about    = get_theme_mod( 'toggle_front_about', false );
$about_headings        = get_theme_mod( 'about_headings' );
$about_subheading      = get_theme_mod( 'about_subheading' );
$notice_headings       = get_theme_mod( 'notice_headings' );
$notice_descriptions   = get_theme_mod( 'notice_descriptions' );
$about_btn_txt         = get_theme_mod( 'about_btn_txt' );
$about_btn_link        = get_theme_mod( 'about_btn_link' );
$front_about_repeaters = get_theme_mod( 'front_about_repeaters' );
$about_image_one       = get_theme_mod( 'about_image_one' );
$image_id_one = attachment_url_to_postid( $about_image_one );

if ( $toggle_front_about && ( ( $about_image_one && $image_id_one ) || $about_subheading || $about_headings || ( $about_btn_txt && $about_btn_link ) || $front_about_repeaters || $notice_headings || $notice_descriptions ) ) { ?>
	<div id="front-about" class="about-section front-about">
		<div class="about-banner">
			<div class="container">
				<div class="about-section-wrapper">
					<div class="about-bottom">
						<div class="about-left">
							<?php if ( $about_headings || $about_subheading ){ ?>
								<div class="text-wrapper">
									<?php if ( $about_headings ) { ?>
										<h2 class="title main-headline section-heading">
											<?php echo esc_html( $about_headings ); ?>	
										</h2>
									<?php } ?>
									<?php if ( $about_subheading ) { ?>
										<span class="headline-highlight front-about"><?php echo esc_html( $about_subheading ); ?></span>
									<?php } ?>
								</div>
							<?php } ?>	
							<div class="about-content-wrapper">
								<?php if ( $notice_headings ) { ?>
									<h3 class="title main-headline">
										<?php echo esc_html( $notice_headings ); ?>
									</h3>
								<?php } ?>
								<?php if ( $notice_descriptions ) { ?>
									<p class="banner-notice-description"><?php echo esc_html( $notice_descriptions ); ?></p>
								<?php } ?>
								
								<?php if ( $about_btn_txt && $about_btn_link ) { ?>
									<a href="<?php echo esc_url( $about_btn_link ); ?>" class="btn btn-primary">
										<?php echo esc_html( $about_btn_txt ); ?>
										<span class="btn-icon">
											<svg width="23" height="24" viewBox="0 0 23 24" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M8.59168 7.86346C8.55925 7.89589 8.53332 7.93434 8.51572 7.9767C8.49813 8.01919 8.48879 8.06538 8.48879 8.11136C8.48885 8.15715 8.49821 8.20232 8.51572 8.24463C8.5333 8.28707 8.55852 8.32608 8.59099 8.35857C8.62347 8.39105 8.6625 8.41624 8.70493 8.43384C8.74741 8.45143 8.79291 8.46146 8.83889 8.46146H14.3576L7.17747 15.6416C7.11183 15.7073 7.07458 15.7967 7.07458 15.8895C7.0747 15.9822 7.11131 16.0712 7.17678 16.1367C7.24242 16.2024 7.33185 16.2396 7.42468 16.2396C7.51749 16.2396 7.60695 16.2024 7.67258 16.1367L14.8528 8.95657V14.4753C14.8529 14.568 14.8895 14.657 14.955 14.7225C15.0206 14.7882 15.11 14.8254 15.2029 14.8254C15.2957 14.8254 15.3851 14.7882 15.4508 14.7225C15.5162 14.657 15.5528 14.568 15.553 14.4753V8.11136C15.553 8.06536 15.5436 8.0192 15.526 7.9767C15.5084 7.93432 15.4825 7.89591 15.4501 7.86346C15.4176 7.83099 15.3793 7.80507 15.3368 7.7875C15.2943 7.76992 15.2488 7.76124 15.2029 7.76126H8.83889C8.79292 7.76126 8.7474 7.76991 8.70493 7.7875C8.66251 7.80507 8.62417 7.83101 8.59168 7.86346Z" fill="White" stroke="#F96900" stroke-width="0.2"/>
											</svg>
										</span>
									</a>
								<?php } ?>
							</div>
						</div>
						<div class="about-right">
							<?php if ( ( $about_image_one && $image_id_one ) ) { ?>
								<div class="img-wrapper angular-image-wrapper">
									<?php
									if ( $image_id_one ) {
										echo wp_get_attachment_image( $image_id_one, 'about_image_one' );
									} 
									?>
									<div class="orange-diagonal"></div>
								</div>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="experience-section">
			<div class="container">
				<div class="features-wrap experience-wrapper">	
					<?php
						$front_about_repeaters = get_theme_mod( 'front_about_repeaters' );
						if ( ! empty( $front_about_repeaters ) && is_string( $front_about_repeaters ) ) {
							$front_about_repeaters = json_decode( $front_about_repeaters, true );
						}
						if ( is_array( $front_about_repeaters ) ) {	
							foreach ( $front_about_repeaters as $abtrepeater ) {
								$text        = ! empty( $abtrepeater['text'] ) ? $abtrepeater['text'] : '';
								$description = ! empty( $abtrepeater['description'] ) ? $abtrepeater['description'] : '';
								if ( $text && $description ) { ?>
									<div class="feature">
										<?php if ( $text ) { ?>
											<h5 class="title experience-heading"><?php echo esc_html( $text ); ?></h5>
										<?php } ?>
										<?php if ( $description ) { ?>
											<?php echo wpautop( wp_kses_post( $description ) ); ?>
										<?php } ?>
									</div>
								<?php }
							}
						}
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
} 
