<?php
/**
 * Extra Functions for Skyline Construction Child Theme
 *
 * @package skyline-construction
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
function constructionn_header_inclusion() {
	$toggle_header = get_theme_mod( 'topbar_toggle', false ); ?>
	<div class="site-header style-one">
		<div class="header-top">
			<?php if ( $toggle_header ) { ?>
				<div class="container">
					<div class="header-top-wrapper">
						<?php constructionn_header_message(); ?>
						<div class="header-top-right">
							<?php constructionn_social_media_repeater( 'header-section' ); ?>
						</div>
					</div>
				</div>
			<?php } ?>
		</div>
		<div class="desktop-header">
			<div class="container">
				<div class="header-wrapper">                       
					<div class="logo-wrapper">
							<?php constructionn_site_branding( true ); ?>
					</div>
					<div class="primary-menu-wrapper">
							<?php constructionn_primary_nagivation(); ?>
						</div>
					<div class="header-right">
						
						<ul class="header-link-list">
							<?php constructionn_front_header_one_request_quote(); ?>
						</ul>
					</div>
				</div>
			</div>
		</div>
		<?php constructionn_mobile_header(); ?>
	</div>
	<?php
}

/**
 * Google Fonts url
 */
function constructionn_google_fonts_url() {
	$fonts_url = '';
	$opensans_font = _x( 'on', 'Open Sans font: on or off', 'skyline-construction' );

	if ( 'off' !== $opensans_font ) {
		$font_families = array(
			'Kumbh+Sans:400,500,600,700',
			'Inter:400,500,600,700',
		);

		$query_args = array(
			'family'  => urlencode( implode( '|', $font_families ) ),
			'subset'  => urlencode( 'latin,latin-ext' ),
			'display' => urlencode( 'fallback' ),
		);

		$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );

		$toggle_localgoogle_fonts = get_theme_mod( 'toggle_localgoogle_fonts', false );

		if( $toggle_localgoogle_fonts ){
			$font_families = array(
				'Kumbh+Sans:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700',
				'Inter:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700',
			);
			
			$fonts_url = add_query_arg( array(
				'family' => implode( '&family=', $font_families ),
				'display' => 'swap',
			), 'https://fonts.googleapis.com/css2' );

			$fonts_url = constructionn_get_webfont_url( esc_url_raw( $fonts_url ) );
		} else{
			$fonts_url = $fonts_url;
		}
	}
	return esc_url( $fonts_url );
}

function constructionn_social_media_repeater() {
	$socialmedia_toggle   = get_theme_mod( 'socialmedia_toggle', false );
	$facebook_link      = get_theme_mod( 'social_facebook_link' );
	$instagram_link     = get_theme_mod( 'social_instagram_link' );
	$linkedin_link      = get_theme_mod( 'social_linkedin_link' );
	$pinterest_link     = get_theme_mod( 'social_pinterest_link' );
	$toggle_social_link = get_theme_mod( 'toggle_social_link', true );

	if ( $socialmedia_toggle && ( $facebook_link || $instagram_link || $linkedin_link || $pinterest_link ) ) { ?>
	<div class="social-wrap">
		<ul class="social-networks">
			<?php
			if ( $facebook_link ) { ?>
					<li>
						<a class="social-link" href="<?php echo esc_url( $facebook_link ); ?>" target="<?php echo esc_attr( $toggle_social_link ); ?>" rel="nofollow noopener">
							<?php echo wp_kses( constructionn_handle_all_svgs( 'facebook' ), constructionn_get_kses_extended_ruleset() ); ?>
						</a>
					</li>
				<?php
			}
			if ( $instagram_link ) { ?>
					<li>
						<a class="social-link" href="<?php echo esc_url( $instagram_link ); ?>" target="<?php echo esc_attr( $toggle_social_link ); ?>" rel="nofollow noopener">
							<?php echo wp_kses( constructionn_handle_all_svgs( 'instagram' ), constructionn_get_kses_extended_ruleset() ); ?>
						</a>
					</li>
				<?php
			}
			if ( $linkedin_link ) { ?>
					<li>
						<a class="social-link" href="<?php echo esc_url( $linkedin_link ); ?>" target="<?php echo esc_attr( $toggle_social_link ); ?>" rel="nofollow noopener">
							<?php echo wp_kses( constructionn_handle_all_svgs( 'linkedin' ), constructionn_get_kses_extended_ruleset() ); ?>
						</a>
					</li>
				<?php
			}
			if ( $pinterest_link ) { ?>
					<li>
						<a href="<?php echo esc_url( $pinterest_link ); ?>" target="<?php echo esc_attr( $toggle_social_link ); ?>" rel="nofollow noopener">
							<?php echo wp_kses( constructionn_handle_all_svgs( 'pinterest' ), constructionn_get_kses_extended_ruleset() ); ?>
						</a>
					</li>
				<?php
			}
			?>
		</ul>
	</div>
		<?php
	}
}

add_filter( 'constructionn_homepage_sections', 'skyline_construction_homepage_sections' );
function skyline_construction_homepage_sections( $sections ) {	
	$sections = array(
		'banner',
		'counter',
		'about',
		'workingstep',
		'testimonial',
		'partner',
		'contact',
		'blog',
	);
	return $sections;
}

add_action( 'init', function() {
    remove_action( 'constructionn_footer', 'constructionn_footer_top', 30 );
} );

function constructionn_footer_bottom() {
	?>
	<div class="footer-bottom">
		<div class="container">
			<div class="footer-bottom-menu-wrappers">
			<?php 
				constructionn_footer_copyright(); 
				constructionn_footer_navigation(); 
				?>
			</div>	
		</div>
	</div>
	<?php
}
/**
 * Breadcrumbs section
 *
 * @return void
 */
function skyline_construction_breadcrumb_background() {
	if ( ! is_front_page() ) {
		$breadcrumb_bg_color = '#F96900';
		$background_style    = 'background: ' . $breadcrumb_bg_color . ';'; ?>
		<div class="breadcrumb-wrapper skyline-construction-breadcrumb" style="<?php echo esc_attr( $background_style ); ?>">
			<div class="container">
				<header class="entry-header">
					<?php constructionn_header_title();?>	
				</header>
				<?php constructionn_breadcrumbs(); ?>
			</div>
		</div>
		<?php
	}
}


