<?php
/**
 * Constructionn Child Theme Customizer
 *
 * @package Constructionn Child
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Add selective refresh partials for about section
 */
function skyline_construction_about_partials( $wp_customize ) {
	// Check if required WordPress functions exist
	if ( ! function_exists( 'add_partial' ) ) {
		return;
	}
	
	// Add selective refresh partial for about headings
	$wp_customize->selective_refresh->add_partial(
		'about_headings',
		array(
			'selector'        => '.front-about .section-heading',
			'render_callback' => function () {
				return esc_html( get_theme_mod( 'about_headings' ) );
			},
		)
	);

	// Add selective refresh partial for about descriptions
	$wp_customize->selective_refresh->add_partial(
		'about_descriptions',
		array(
			'selector'        => '.front-about .right-top',
			'render_callback' => function () {
				return esc_html( get_theme_mod( 'about_descriptions' ) );
			},
		)
	);

	// Add selective refresh partial for notice headings
	$wp_customize->selective_refresh->add_partial(
		'notice_headings',
		array(
			'selector'        => '.front-about .main-headline:not(.section-heading)',
			'render_callback' => function () {
				return esc_html( get_theme_mod( 'notice_headings' ) );
			},
		)
	);

	// Add selective refresh partial for notice descriptions
	$wp_customize->selective_refresh->add_partial(
		'notice_descriptions',
		array(
			'selector'        => '.front-about .banner-notice-description',
			'render_callback' => function () {
				return esc_html( get_theme_mod( 'notice_descriptions' ) );
			},
		)
	);

	// Add selective refresh partial for about button text
	$wp_customize->selective_refresh->add_partial(
		'about_btn_txt',
		array(
			'selector'        => '.front-about .btn.has-icon.btn__primary',
			'render_callback' => function () {
				return esc_html( get_theme_mod( 'about_btn_txt' ) );
			},
		)
	);
}
add_action( 'customize_register', 'skyline_construction_about_partials', 30 );


	
/**
 * Remove unused customizer settings from parent theme
 */
function skyline_construction_remove_unused_settings( $wp_customize ) {

	// Remove social media section Heading
	if ( $wp_customize->get_control( 'socialmedia_heading' ) ) {
		$wp_customize->remove_control( 'socialmedia_heading' );
	}

    // Remove about second heading
	if ( $wp_customize->get_control( 'about_subheading' ) ) {
		$wp_customize->remove_control( 'about_subheading' );
	}
	

	// Remove CTA section entirely
	if ( $wp_customize->get_section( 'cta_section' ) ) {
		$wp_customize->remove_section( 'cta_section' );
	}
	
	// Remove all CTA-related controls
	if ( $wp_customize->get_control( 'toggle_front_cta' ) ) {
		$wp_customize->remove_control( 'toggle_front_cta' );
	}
	if ( $wp_customize->get_control( 'front_cta_heading' ) ) {
		$wp_customize->remove_control( 'front_cta_heading' );
	}
	if ( $wp_customize->get_control( 'front_cta_descs' ) ) {
		$wp_customize->remove_control( 'front_cta_descs' );
	}
	if ( $wp_customize->get_control( 'contact_number' ) ) {
		$wp_customize->remove_control( 'contact_number' );
	}
	
	// Remove banner section button text two
	if ( $wp_customize->get_control( 'b_three_btn_txt_two' ) ) {
		$wp_customize->remove_control( 'b_three_btn_txt_two' );
	}
	// Remove banner section button link two
	if ( $wp_customize->get_control( 'b_three_btn_link_two' ) ) {
		$wp_customize->remove_control( 'b_three_btn_link_two' );
	}	
	// Remove unused frontpage banner settings
	if ( $wp_customize->get_control( 'banner_background' ) ) {
		$wp_customize->remove_control( 'banner_background' );
	}
	
	// Remove unused footer settings
	if ( $wp_customize->get_control( 'footer_logos_slider_custom' ) ) {
		$wp_customize->remove_control( 'footer_logos_slider_custom' );
	}
	
	if ( $wp_customize->get_control( 'footer_custom_logo' ) ) {
		$wp_customize->remove_control( 'footer_custom_logo' );
	}
	
	if ( $wp_customize->get_control( 'footer_contactform_shortcode' ) ) {
		$wp_customize->remove_control( 'footer_contactform_shortcode' );
	}
	
	if ( $wp_customize->get_control( 'toggle_footer_contactform' ) ) {
		$wp_customize->remove_control( 'toggle_footer_contactform' );
	}

	// Remove unused frontpage about settings
	if ( $wp_customize->get_control( 'about_descriptions' ) ) {
		$wp_customize->remove_control( 'about_descriptions' );
	}
	
	if ( $wp_customize->get_control( 'about_image_two' ) ) {
		$wp_customize->remove_control( 'about_image_two' );
	}
}
add_action( 'customize_register', 'skyline_construction_remove_unused_settings', 999 );

/**
 * Active callback for contact section
 */
if ( ! function_exists( 'skyline_front_contact_active_callback' ) ) :
function skyline_front_contact_active_callback( $control ) {
	$toggle_section = $control->manager->get_setting( 'toggle_front_contact' )->value();
	if ( ! $toggle_section ) {
		return false;
	}

	$allowed_ids = array(
		'contact_extra_info',
		'contact_info_heading',
		'contact_phone_label',
		'contact_phone_number',
	);

	return in_array( $control->id, $allowed_ids, true );
}
endif;


add_action( 'customize_register', 'skyline_construction_contact_partials', 15 );

/**
 * Partial for contact section
 */
function skyline_construction_contact_partials( $wp_customize ) {
	
	$wp_customize->selective_refresh->add_partial(
		'contact_descriptions',
		array(
			'selector'        => '.front-contact .section-meta-wrap .left-description',
			'render_callback' => function () {
				return esc_html( get_theme_mod( 'contact_descriptions' ) );
			},
		)
	);
}
add_action( 'customize_register', 'skyline_construction_contact_fields', 20 );

/**
 * Fields for contact section
 */
function skyline_construction_contact_fields( $wp_customize ) {
	$wp_customize->add_setting(
		'contact_extra_info',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		)
	);

	// Selective refresh: Extra info paragraph (right side black box contact section)
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'contact_extra_info',
			array(
				'selector'        => '.front-contact .contact-info-box .section-card-wrap .right-extra-info',
				'render_callback' => function () {
					return esc_html( get_theme_mod( 'contact_extra_info' ) );
				},
			)
		);
	}

	$wp_customize->add_control(
		'contact_extra_info',
		array(
			'label'           => __( 'Extra Info', 'skyline-construction' ),
			'section'         => 'contact_section',
			'type'            => 'text',
			'active_callback' => 'skyline_front_contact_active_callback',
		)
	);

	// Heading for the right contact info card
	$wp_customize->add_setting(
		'contact_info_heading',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		)
	);

	// Selective refresh: Info card heading
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'contact_info_heading',
			array(
				'selector'        => '.front-contact .contact-info-box .section-card-wrap .section-heading',
				'render_callback' => function () {
					return esc_html( get_theme_mod( 'contact_info_heading' ) );
				},
			)
		);
	}

	$wp_customize->add_control(
		'contact_info_heading',
		array(
			'label'           => __( 'Info Box Heading', 'skyline-construction' ),
			'section'         => 'contact_section',
			'type'            => 'text',
			'active_callback' => 'skyline_front_contact_active_callback',
		)
	);

	// Phone label text (e.g., "Reach Out Now:")
	$wp_customize->add_setting(
		'contact_phone_label',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		)
	);

	// Selective refresh: Phone label text
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'contact_phone_label',
			array(
				'selector'        => '.front-contact .contact-info-box .contact-phone .phone-text',
				'render_callback' => function () {
					return esc_html( get_theme_mod( 'contact_phone_label' ) );
				},
			)
		);
	}

	$wp_customize->add_control(
		'contact_phone_label',
		array(
			'label'           => __( 'Phone Label', 'skyline-construction' ),
			'section'         => 'contact_section',
			'type'            => 'text',
			'active_callback' => 'skyline_front_contact_active_callback',
		)
	);

	// Phone number text
	$wp_customize->add_setting(	
		'contact_phone_number',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		)
	);

	// Selective refresh: Phone number text
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'contact_phone_number',
			array(
				'selector'        => '.front-contact .contact-info-box .contact-phone .phone-number',
				'render_callback' => function () {
					return esc_html( get_theme_mod( 'contact_phone_number' ) );
				},
			)
		);
	}

	$wp_customize->add_control(
		'contact_phone_number',
		array(
			'label'           => __( 'Phone Number', 'skyline-construction' ),
			'section'         => 'contact_section',
			'type'            => 'text',
			'active_callback' => 'skyline_front_contact_active_callback',
		)
	);
}



/**
 * Function to override the useful links in the customizer
 * @param $customizer_manager
 * 
 */
 function constructionn_theme_info( $customizer_manager ) {
	$customizer_manager->add_section(
		'theme_info',
		array(
			'title'    => esc_html__( 'Information Links', 'skyline-construction' ),
			'priority' => 6,
		)
	);

	/** Important Links */
	$customizer_manager->add_setting(
		'theme_info_theme',
		array(
			'default'           => '',
			'sanitize_callback' => 'wp_kses_post',
		)
	);

	$theme_info  = '<ul>';
	$theme_info .= sprintf( __( '<li>View documentation: %1$sClick here.%2$s</li>', 'skyline-construction' ), '<a href="' . esc_url( 'https://glthemes.com/documentation/constructionn/' ) . '" target="_blank">', '</a>' );
	$theme_info .= sprintf( __( '<li>Theme info: %1$sClick here.%2$s</li>', 'skyline-construction' ), '<a href="' . esc_url( 'https://glthemes.com/wordpress-theme/skyline-construction/' ) . '" target="_blank">', '</a>' );
	$theme_info .= sprintf( __( '<li>Support ticket: %1$sClick here.%2$s</li>', 'skyline-construction' ), '<a href="' . esc_url( 'https://glthemes.com/support/' ) . '" target="_blank">', '</a>' );
	$theme_info .= sprintf( __( '<li>More WordPress Themes: %1$sClick here.%2$s</li>', 'skyline-construction' ), '<a href="' . esc_url( 'https://glthemes.com/wordpress-theme/' ) . '" target="_blank">', '</a>' );
	$theme_info .= '</ul>';

	$customizer_manager->add_control(
		new Constructionn_Note_Control(
			$customizer_manager,
			'theme_info_theme',
			array(
				'label'       => esc_html__( 'Important Links', 'skyline-construction' ),
				'section'     => 'theme_info',
				'description' => $theme_info,
			)
		)
	);

	$customizer_manager->add_section(
		new Constructionn_Customize_Section_Pro(
			$customizer_manager,
			'skyline_view_pro',
			array(
						'title'    => esc_html__( 'Pro Available', 'skyline-construction' ),
		'priority' => 5,
		'pro_text' => esc_html__( 'VIEW PRO THEME', 'skyline-construction' ),
				'pro_url'  => 'https://glthemes.com/wordpress-theme/constructionn-pro/',
			)
		)
	);
}








