<?php 
/**
 * Skyline Construction Child functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Skyline Construction Child
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



/**
 * Enqueue parent and child theme styles and scripts
 */
function skyline_construction_child_setuptheme(){

	load_theme_textdomain( 'skyline-construction-child', get_stylesheet_directory() . '/languages' );

	add_image_size( 'testimonial_image', 414, 373, true );
	add_image_size( 'blog_card_img', 482, 314, true );
	add_image_size( 'about_image_one', 528, 632, true );
}
add_action( 'after_setup_theme', 'skyline_construction_child_setuptheme', 20 );

function skyline_construction_child_enqueue_assets() {
	$my_theme = wp_get_theme();
	$version  = $my_theme['Version'];

	// Enqueue parent theme styles
	wp_enqueue_style( 'constructionn', get_template_directory_uri() . '/style.css' );
	
	// Enqueue child theme styles
	wp_enqueue_style( 'skyline-construction-child', get_stylesheet_directory_uri() . '/style.css', array('constructionn'), $version );
	
}
add_action( 'wp_enqueue_scripts', 'skyline_construction_child_enqueue_assets', 20 );

/**
 * Customizer settings
 */ 	
require get_stylesheet_directory() . '/inc/customizer.php';

/**
 * Extra Functions
 */
require get_stylesheet_directory() . '/inc/extra-functions.php';
