<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package SKT Girlie Lite
 */
?>
<div id="footer-wrapper">
    	<div class="container">
            <div class="cols-3 widget-column-1">  
            <?php $about_title = get_theme_mod('about_title'); ?>	
            <?php if (!empty($about_title)) { ?><h5><?php echo esc_html($about_title);?></h5><?php } ?>
				  <?php $about_description = get_theme_mod('about_description'); ?>	
                  <?php if (!empty($about_description)) { ?><p><?php echo esc_html($about_description);?></p><?php } ?>  
                 <div class="social-icons">
                 <?php $fb_link = get_theme_mod('fb_link'); ?>	
				  <?php if (!empty($fb_link)) { ?>
                  <a title="facebook" class="fb" target="_blank" href="<?php echo esc_url($fb_link);?>"></a>
                  <?php } ?>
                  <?php $twitt_link = get_theme_mod('twitt_link'); ?>
				  <?php if (!empty($twitt_link)) { ?>
                  <a title="twitter" class="tw" target="_blank" href="<?php echo esc_url($twitt_link);?>"></a>
                  <?php } ?>
                  <?php $insta_link = get_theme_mod('insta_link'); ?>
                  <?php if (!empty($insta_link)) { ?>
                  <a title="instagram" class="gp" target="_blank" href="<?php echo esc_url($insta_link);?>"></a>
                  <?php }?>
                  <?php $linked_link = get_theme_mod('linked_link'); ?>
                  <?php if (!empty($linked_link)) { ?>
                  <a title="linkedin" class="in" target="_blank" href="<?php echo esc_url($linked_link);?>"></a>
                <?php } ?>
                  </div>          	
            </div><!--end .col-3-->
             <div class="cols-3 widget-column-2">  
             	<?php $recentpost_title = get_theme_mod('recentpost_title'); ?>
                <?php if (!empty($recentpost_title)) { ?><h5><?php echo esc_html($about_title);?></h5><?php } ?>
					<?php $args = array( 'posts_per_page' => 2, 'post__not_in' => get_option('sticky_posts'), 'orderby' => 'date', 'order' => 'desc' );
					$the_query = new WP_Query( $args );
					?>
                    <?php while ( $the_query->have_posts() ) :  $the_query->the_post(); ?>
                        <div class="recent-post">
                         <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('thumbnail'); ?></a>
                         <a href="<?php the_permalink(); ?>"><h6><?php the_title(); ?></h6></a>                         
                         <?php the_excerpt(); ?>                         
                        </div>
                 <?php endwhile; ?>
              </div><!--end .col-3-->
               <div class="cols-3 widget-column-3">
				  <?php $contact_title = get_theme_mod('contact_title'); ?>
                  <?php if (!empty($contact_title)) { ?><h5><?php echo esc_html($contact_title);?></h5><?php } ?>
 					<?php $contact_add = get_theme_mod('contact_add'); ?>
                   <?php if (!empty($contact_add)) { ?>
                    <span class="mapicon"><?php echo esc_html($contact_add);?></span>
                  <?php } ?>
                  <?php $contact_no = get_theme_mod('contact_no'); ?>
				  <?php if (!empty($contact_no)) { ?>
                    <span class="phoneno"><?php echo esc_html($contact_no);?></span>
                  <?php } ?>
                  <?php $contact_mail = get_theme_mod('contact_mail'); ?>
                  <a href="mailto:<?php echo esc_attr( antispambot( sanitize_email( $contact_mail ) ) ); ?>"><span class="emailicon"><?php echo esc_html( antispambot( sanitize_email( $contact_mail ) ) ); ?></span></a>
                </div><!--end .col-3-->
            <div class="clear"></div>
         </div><!--end .container-->
       <div class="copyright-wrapper">
        	<div class="container">
            	<div class="copyright-txt">
				<?php echo esc_attr('&copy; '.date('Y').'');?>&nbsp;<?php bloginfo('name');?>&nbsp;<?php esc_attr_e('All Rights Reserved.','skt-girlie-lite');?> <?php bloginfo('name'); ?> <?php esc_html_e('Theme By ','skt-girlie-lite');?> <a href="<?php echo esc_url('https://www.sktthemes.org/product-category/blog-wordpress-themes/');?>" target="_blank">
        <?php esc_html_e('SKT Blog Themes','skt-girlie-lite'); ?>
        </a>           
         </div>                
            </div>
        </div>
    </div><!--end .footer-->
<?php wp_footer(); ?>
</body>
</html>