<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @license GPL 2.0
 */
get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main">

		<?php if ( have_posts() ) { ?>

			<?php if ( siteorigin_page_setting( 'page_title' ) ) { ?>
				<header>
					<?php if ( single_post_title( '', false ) ) { ?>
						<h1 class="page-title"><?php single_post_title(); ?></h1>
					<?php } else { ?>
						<h1 class="page-title">
							<?php echo get_bloginfo( 'name' ); ?>
						</h1>
					<?php } ?>
					<?php siteorigin_north_breadcrumbs(); ?>
				</header>
			<?php } ?>

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) {
				the_post(); ?>

				<?php
				/*
				 * Include the Post-Format-specific template for the content.
				 * If you want to override this in a child theme, then include a file
				 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
				 */
				get_template_part( 'template-parts/content', get_post_format() );
				?>

			<?php } ?>

			<?php siteorigin_north_posts_pagination(); ?>

		<?php } else { ?>

			<?php get_template_part( 'template-parts/content', 'none' ); ?>

		<?php } ?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>
