# Simplifii WordPress FSE Theme

<div aria-hidden="true">

[![Total Downloads](http://poser.pugx.org/leogopal/simplifii/downloads)](https://packagist.org/packages/leogopal/simplifii)
![Auto Assign](https://github.com/leogopal/simplifii/actions/workflows/auto-assign.yml/badge.svg?style=for-the-badge)
[![Code Quality PHP](https://github.com/leogopal/simplifii/actions/workflows/lint-php.yml/badge.svg?style=for-the-badge)](https://github.com/leogopal/simplifii/actions/workflows/lint-php.yml)
[![Code Quality CSS](https://github.com/leogopal/simplifii/actions/workflows/lint-css.yml/badge.svg?style=for-the-badge)](https://github.com/leogopal/simplifii/actions/workflows/lint-css.yml)
[![DevSkim](https://github.com/leogopal/simplifii/actions/workflows/devskim.yml/badge.svg?style=for-the-badge)](https://github.com/leogopal/simplifii/actions/workflows/devskim.yml)
[![Generate POT file](https://github.com/leogopal/simplifii/actions/workflows/pot.yml/badge.svg?style=for-the-badge)](https://github.com/leogopal/simplifii/actions/workflows/pot.yml)
[![WordPress version checker](https://github.com/leogopal/simplifii/actions/workflows/wp-version-checker.yml/badge.svg?style=for-the-badge)](https://github.com/leogopal/simplifii/actions/workflows/wp-version-checker.yml)
[![Website](https://img.shields.io/badge/website-000000?style=for-the-badge&logo=About.me&logoColor=white)](https://leogopal.com)
[![VS Code](https://img.shields.io/badge/Visual_Studio_Code-0078D4?style=for-the-badge&logo=visual%20studio%20code&logoColor=white)]()
[![Dev.to](https://img.shields.io/badge/dev.to-0A0A0A?style=for-the-badge&logo=devdotto&logoColor=white)]()
[![WordPress](https://img.shields.io/badge/Wordpress-21759B?style=for-the-badge&logo=wordpress&logoColor=white)]()
[![EsLint](https://img.shields.io/badge/Editor%20Config-E0EFEF?style=for-the-badge&logo=editorconfig&logoColor=000)]()
[![eslint](https://img.shields.io/badge/eslint-3A33D1?style=for-the-badge&logo=eslint&logoColor=white)]()
[![Prettier](https://img.shields.io/badge/prettier-1A2C34?style=for-the-badge&logo=prettier&logoColor=F7BA3E)]()
[![Stylelint](https://img.shields.io/badge/stylelint-000?style=for-the-badge&logo=stylelint&logoColor=white)]()
[![Figma](https://img.shields.io/badge/Figma-F24E1E?style=for-the-badge&logo=figma&logoColor=white)]()
[![iterm](https://img.shields.io/badge/iTerm2-000000?style=for-the-badge&logo=iterm2&logoColor=white)]()
[![git](https://img.shields.io/badge/GIT-E44C30?style=for-the-badge&logo=git&logoColor=white)]()
[![chrome](https://img.shields.io/badge/Google_chrome-4285F4?style=for-the-badge&logo=Google-chrome&logoColor=white)]()
[![maintained](https://img.shields.io/badge/Maintained%3F-yes-green?style=for-the-badge)]()
[![built](http://ForTheBadge.com/images/badges/built-with-love.svg?style=for-the-badge)]()
[![github](https://img.shields.io/badge/GitLab-330F63?style=for-the-badge&logo=gitlab&logoColor=white)]()
[![twitter](https://img.shields.io/badge/Twitter-1DA1F2?style=for-the-badge&logo=twitter&logoColor=white)]()
[![patreon](https://img.shields.io/badge/Patreon-F96854?style=for-the-badge&logo=patreon&logoColor=white)](https://www.patreon.com/leogopal)
[![paypal](https://img.shields.io/badge/PayPal-00457C?style=for-the-badge&logo=paypal&logoColor=white)]()
[![sponsor](https://img.shields.io/badge/sponsor-30363D?style=for-the-badge&logo=GitHub-Sponsors&logoColor=#white)]()
[![coffee](https://img.shields.io/badge/Buy_Me_A_Coffee-FFDD00?style=for-the-badge&logo=buy-me-a-coffee&logoColor=black)](https://www.buymeacoffee.com/leogopal)
[![freelancer](https://img.shields.io/badge/Freelancer-29B2FE?style=for-the-badge&logo=Freelancer&logoColor=white)]()

### stats

[![Tested on PHP 5.4 to 7.4 snapshot](https://img.shields.io/badge/tested%20on-PHP%205.4%20|%205.5%20|%205.6%20|%207.0%20|%207.1%20|%207.2%20|%207.3%20|%207.4snapshot-green.svg?maxAge=2419200&style=for-the-badge)](https://github.com/leogopal/simplifii/actions/workflows/lint-php.yml)
[![Release Date of the Latest Version](https://img.shields.io/github/release-date/leogopal/simplifii.svg?maxAge=1800&style=for-the-badge)](https://github.com/leogopal/simplifii/releases)
[![Number of Contributors](https://img.shields.io/github/contributors/leogopal/simplifii.svg?maxAge=3600&style=for-the-badge)](https://github.com/leogopal/simplifii/graphs/contributors)
[![Last Commit](https://img.shields.io/github/last-commit/leogopal/simplifii/main.svg?style=for-the-badge)](https://github.com/leogopal/simplifii/commits/main)
[![Minimum PHP Version](https://img.shields.io/packagist/php-v/leogopal/simplifii.svg?maxAge=3600&style=for-the-badge)](https://packagist.org/packages/leogopal/simplifii)
[![release](https://img.shields.io/github/release/leogopal/simplifii.svg?style=for-the-badge)]()
[![commits since](https://img.shields.io/github/commits-since/leogopal/simplifii/v1.1.0.svg?style=for-the-badge)]()
[![closed issues](https://img.shields.io/github/issues-closed/leogopal/simplifii.svg?style=for-the-badge)]()
[![PR closed](https://img.shields.io/github/issues-pr-closed/leogopal/simplifii.svg?style=for-the-badge)]()
[![Codeable](https://shields.io/badge/codeable-grey?logo=data:image/webp;base64,UklGRpgAAABXRUJQVlA4TIsAAAAvGUAGEC9AkG3T+dOc8BrzTyBps61/gZc9ZAEmQxlAFPnz9BbA7rCUu1g4qm3baS5NwGEtBNQ5EiCJgO7fy2ujCIjoP9q2baMk5dZD9H/ThY7Q+Q7tvbcxWE9u7sjLmph7FwYTbi68TAwXfuDEiJ1j0dyr4iZlwkcFN8kpdLKRZCSaCWbcgqVSesgTAA==&style=for-the-badge)]()
[![license](https://img.shields.io/github/license/leogopal/simplifii.svg?style=for-the-badge)]()

</div>

This theme is designed as a block theme to support WordPress full site editing. You must have the Gutenberg Plugin Activate to use this theme before ready for full site editing on released WordPress.

> ### [**Get the Simplifii theme on WordPress.org →**](https://wordpress.org/themes/simplifii/)

![screenshot](https://user-images.githubusercontent.com/4948323/187812605-6ba0c71d-a08c-4123-91eb-42ff7373ba89.png)

</div>

</div>

<div class="theme-info">

<div class="screenshot"><picture><source media="(min-width: 782px)" srcset="https://i0.wp.com/themes.svn.wordpress.org/simplifii/1.5.0/screenshot.png?w=572&amp;strip=all, https://i0.wp.com/themes.svn.wordpress.org/simplifii/1.5.0/screenshot.png?w=1144&amp;strip=all 2x"><source media="(min-width: 481px) and (max-width: 782px)" srcset="https://i0.wp.com/themes.svn.wordpress.org/simplifii/1.5.0/screenshot.png?w=700&amp;strip=all, https://i0.wp.com/themes.svn.wordpress.org/simplifii/1.5.0/screenshot.png?w=1400&amp;strip=all 2x"><source media="(min-width: 401px) and (max-width: 480px)" srcset="https://i0.wp.com/themes.svn.wordpress.org/simplifii/1.5.0/screenshot.png?w=420&amp;strip=all, https://i0.wp.com/themes.svn.wordpress.org/simplifii/1.5.0/screenshot.png?w=840&amp;strip=all 2x"><source media="(max-width: 400px)" srcset="https://i0.wp.com/themes.svn.wordpress.org/simplifii/1.5.0/screenshot.png?w=344&amp;strip=all, https://i0.wp.com/themes.svn.wordpress.org/simplifii/1.5.0/screenshot.png?w=688&amp;strip=all 2x">![](https://i0.wp.com/themes.svn.wordpress.org/simplifii/1.5.0/screenshot.png?w=572&strip=all)</picture></div>

<div class="theme-description entry-summary">

Simplifii is a versatile block-based WordPress theme with Full Site Editing allowing you to customise to your hearts content - with WooCommerce support. You must have the Gutenberg Plugin Activate to use this theme before ready for full site editing on released WordPress.

</div>

[Preview](https://wp-themes.com/simplifii/) [Download](https://downloads.wordpress.org/theme/simplifii.1.5.0.zip)

### Tags:

[Block Editor Patterns](https://wordpress.org/themes/tags/block-patterns/), [Block Editor Styles](https://wordpress.org/themes/tags/block-styles/), [Blog](https://wordpress.org/themes/tags/blog/), [Custom Background](https://wordpress.org/themes/tags/custom-background/), [Custom Colors](https://wordpress.org/themes/tags/custom-colors/), [Custom Logo](https://wordpress.org/themes/tags/custom-logo/), [Custom Menu](https://wordpress.org/themes/tags/custom-menu/), [E-Commerce](https://wordpress.org/themes/tags/e-commerce/), [Editor Style](https://wordpress.org/themes/tags/editor-style/), [Featured Images](https://wordpress.org/themes/tags/featured-images/), [Four Columns](https://wordpress.org/themes/tags/four-columns/), [Full Site Editing](https://wordpress.org/themes/tags/full-site-editing/), [Grid Layout](https://wordpress.org/themes/tags/grid-layout/), [One Column](https://wordpress.org/themes/tags/one-column/), [Sticky Post](https://wordpress.org/themes/tags/sticky-post/), [Threaded Comments](https://wordpress.org/themes/tags/threaded-comments/), [Three Columns](https://wordpress.org/themes/tags/three-columns/), [Translation Ready](https://wordpress.org/themes/tags/translation-ready/), [Two Columns](https://wordpress.org/themes/tags/two-columns/), [Wide Blocks](https://wordpress.org/themes/tags/wide-blocks/)

</div>

## Contributing

If you would like to contribute code, the list of [open issues](https://github.com/leogopal/simplifii/issues) is a great place to start looking for tasks. [Pull requests](https://github.com/leogopal/simplifii/pulls) are preferred when linked to an existing issue.

Contributing is not just for developers! There are many opportunities to help with [testing](#getting-started), triage, discussion, designing and building variations, and more. Please look through [open issues](https://github.com/leogopal/simplifii/issues), and join in wherever you feel most comfortable.

### Contributing Style Variations

A big part of Simplifii is to emphasize a diverse collection of style variations, so this is a great way to contribute to the theme!

#### Design a style variation

This can be done a few different ways, including:

-   Create an alternate theme.json file to the one provided by the theme and change values directly in the code.
-   Make changes in the Global Styles panel in the Site Editor. You can save these changes as a new style variation using the [Create Block Theme plugin](https://wordpress.org/plugins/create-block-theme/).
-   Design static mockups in Figma or a similar program.

#### Submit your style variation

When you're ready to submit, please create a new issue and share your designs:

-   Theme.json files can be submitted as code or as zip files.
-   Add images that showcase the look & feel of the variation.
-   Include a style guide with design specifications — this should include details on typography, colors, spacing, etc. Here’s an [example](https://www.figma.com/community/file/1136340417938880987).

### Getting Started

To get started with development:

1.  Set up a WordPress instance, we recommend [wp-env](https://developer.wordpress.org/block-editor/handbook/tutorials/devenv/) or [Local](https://localwp.com/) as an alternative to docker.
2.  Install the [Gutenberg plugin](https://wordpress.org/plugins/gutenberg/)
3.  Clone / download this repository into your `/wp-content/themes/` directory

### Tips for Contributors

-   Similar to Simplifii, a goal for the theme is to have as little CSS as possible. Much of the theme's visual treatments should be handled by the Block Editor and Global Styles. As a general rule, if multiple themes would benefit from the CSS you're considering adding, it might reasonably be provided by Gutenberg instead. Let's include clear code comments for any CSS we do include.
-   Similarly, let's refrain from building any custom-built PHP or JavaScript-based workarounds for functionality that might reasonably be provided by the Block Editor. Simplifii will be a block theme, so let's keep its code simple.
-   In accordance to those last two bullets, this theme has no required build process.
-   If you've helped contribute to the theme in any way, you deserve credit! Folks will be updating [CONTRIBUTORS.md](CONTRIBUTORS.md) periodically with names of contributors, but feel free to open a PR or issue if we leave someone out.

## Requirements

-   Gutenberg plugin (latest)
-   WordPress 5.9+
-   PHP 5.6+
-   License: [GPLv2](http://www.gnu.org/licenses/gpl-2.0.html) or later

Some theme features / PRs may require Gutenberg trunk and will be described or tagged accordingly.

## Resources

-   [Simplifii Figma Mockups](https://www.figma.com/file/OxgciXlJT84BH1083xFjCY/Simplifii-Theme?node-id=301%3A469)
-   [Create Block Theme plugin](https://github.com/WordPress/create-block-theme)
-   [Block Theme documentation](https://developer.wordpress.org/block-editor/how-to-guides/themes/block-theme-overview)
-   [Global Styles & theme.json documentation](https://developer.wordpress.org/block-editor/how-to-guides/themes/theme-json/)
