<?php
/* Registar Sidebars */
/* -------------------------------------------------------------------------- */
$simpleRoundWidgetArgs = array(
    'name'          => 'Simple Round Sidebar',
    'before_widget' => '<div class="widget">',
    'after_widget'  => '</div></div>',
    'before_title'  => '<div class="widgetHead">',
    'after_title'   => '</div><div class="widgetBody">' );

if ( function_exists('register_sidebar') ) {
    register_sidebar($simpleRoundWidgetArgs);
}

$GLOBALS['content_width'] = 538;


function SimpleRound_gallery_shortcode($null, $attr=array()) {
	global $post;

	static $instance = 0;
	$instance++;

	// We're trusting author input, so let's at least make sure it looks like a valid orderby statement
	if ( isset( $attr['orderby'] ) ) {
		$attr['orderby'] = sanitize_sql_orderby( $attr['orderby'] );
		if ( !$attr['orderby'] )
			unset( $attr['orderby'] );
	}

	extract(shortcode_atts(array(
		'order'      => 'ASC',
		'orderby'    => 'menu_order ID',
		'id'         => $post->ID,
		'itemtag'    => 'dl',
		'icontag'    => 'dt',
		'captiontag' => 'dd',
		'columns'    => 3,
		'size'       => 'thumbnail'
	), $attr));

	$id = intval($id);
	$attachments = get_children( array('post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );

	if ( empty($attachments) )
		return '';

	if ( is_feed() ) {
		$output = "\n";
		foreach ( $attachments as $att_id => $attachment )
			$output .= wp_get_attachment_link($att_id, $size, true) . "\n";
		return $output;
	}

	$itemtag = tag_escape($itemtag);
	$captiontag = tag_escape($captiontag);
	$columns = intval($columns);
	$itemwidth = $columns > 0 ? floor(100/$columns) : 100;

    $selector = "gallery-{$instance}";

	$output = "<div id='$selector' class='gallery galleryid-{$id}'>";


	$i = 0;
	foreach ( $attachments as $id => $attachment ) {
		$link = isset($attr['link']) && 'file' == $attr['link'] ? wp_get_attachment_link($id, $size, false, false) : wp_get_attachment_link($id, $size, true, false);
		$SimpleRoundImage = wp_get_attachment_image_src($id, $size, true );

		$output .= "<{$itemtag} class='gallery-item' style='width: {$itemwidth}%;'>";
		$output .= "
			<{$icontag} class='gallery-icon'>
				$link
			</{$icontag}>";
		if ( $captiontag && trim($attachment->post_excerpt) ) {
			$output .= "
				<{$captiontag} class='gallery-caption' style='width: {$SimpleRoundImage[1]}px;'>
				" . wptexturize($attachment->post_excerpt) . "
				</{$captiontag}>";
		}
		$output .= "</{$itemtag}>";
		if ( $columns > 0 && ++$i % $columns == 0 )
			$output .= '<br style="clear: both" />';
	}

	$output .= "
			<br style='clear: both;' />
		</div><div style='clear: both;'></div>\n";

	return $output;
}

add_filter('post_gallery', 'SimpleRound_gallery_shortcode', 10, 2);


function SimpleRound_remove_widgets() {
    if (function_exists('wp_unregister_sidebar_widget')){
        wp_unregister_sidebar_widget('Search');
    }
    if (function_exists('unregister_widget')){
        unregister_widget('WP_Widget_Search');
    }
}

add_action('widgets_init','SimpleRound_remove_widgets');