<?php 
$themename = "Simple Indy";
$shortname = "Simple Indy";

# Template Location
define('THEME', get_bloginfo('template_url'), true);
# JS files location
define('THEME_JS', THEME . '/scripts/js', true);

wp_enqueue_script('jquery');
wp_enqueue_script('jquery-ui-core');
wp_enqueue_script('jquery-ui-tabs');
wp_enqueue_script('menu', THEME_JS .'/menu.js', array('jquery'));
wp_enqueue_script('easySlider1.5', THEME_JS .'/easySlider1.5.js', array('jquery'));
wp_enqueue_script('tabEffects', THEME_JS .'/tabEffects.js', array('jquery'));
wp_enqueue_script('slide', THEME_JS .'/slide.js', array('jquery'));

function theme_add_admin() {

 global $themename, $shortname, $options;   

if ( $_GET['page'] == basename(__FILE__) ) {
	if ( 'sindy_update' == $_REQUEST['action'] ) {
		
		update_option('sindy_featured', $_REQUEST['sindy_featured']);
		update_option('sindy_featured_count', $_REQUEST['sindy_featured_count']);
		update_option('sindy_med_featured', $_REQUEST['sindy_med_featured']);	
		update_option('sindy_footer', $_REQUEST['sindy_footer']);
		update_option('sindy_thumbnail', $_REQUEST['sindy_thumbnail']);	
		
	}
	
}
 
	add_theme_page($themename." Options", "".$themename." Options", 'edit_themes', basename(__FILE__), 'theme_admin');
}

function theme_admin() {

    global $themename, $shortname, $options;   
?>
 <div class="wrap">
 <h2>Simpleindy Theme Settings</h2>
 <script type="text/javascript">
 <!--
      function toggleVisibility(id) {
         var e = document.getElementById(id);
         if(e.style.display == 'block')
            e.style.display = 'none';
         else
           e.style.display = 'block';
      }
 //-->
 </script> 
 </div>

 <?php       
        $message = null;
        $message_updated = __("SimpleIndy Theme Settings Updated.");

        // update options
        if ( $_REQUEST['saved'] ) {
            $message = $message_updated;
            
			/*$upd_options['sindy_featured'] = $_POST['sindy_featured'];
			$upd_options['sindy_featured_count'] = $_POST['sindy_featured_count'];
			$upd_options['sindy_footer'] = $_POST['sindy_footer'];
			$upd_options['sindy_thumbnail'] = $_POST['sindy_thumbnail'];
			
			update_option('sindy_options', $upd_options);
			$sindy_options = get_option('sindy_options');  */		
              
        }
        ?>
<?php if ($message) : ?>
<div id="message" class="updated fade"><p><?php echo $message; ?></p></div>
<?php endif; ?>
<div class="wrap">
 <h3><?php _e('Click on option titles to get help!') ?></h3>

 <form method="post">
 <table class="form-table"> 						
 <tr>
 <th scope="row" style="text-align:right; vertical-align:top;">
 <a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility ('sindy_featured_tip');">
 <?php _e('Disable Featured Content:')?>
 </td>
 <td>
 <input type="checkbox" name="sindy_featured" id="sindy_featured" value="true" <?php if ( get_option('sindy_featured')) { echo "checked=\"0\""; } else {"";} ?>" />
 <div style="max-width:500px; text-align:left; display:none" id="sindy_featured_tip">
 <?php
 _e('Check this if you want to disable Featured Posts Section in the theme');
  ?>
 </div>
 </td>
 </tr>
 
 <tr>
<th scope="row" style="text-align:right; vertical-align:top;">
<a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility('sindy_featured_count_tip');">
<?php _e('Set number of Featured posts:')?>
</a>
</td>
<td>
<input size="1" name="sindy_featured_count" value="<?php if ( get_option('sindy_featured_count') != "") { echo stripcslashes(get_option('sindy_featured_count')); } else {echo '10';}?>"/>
<div style="max-width:500px; text-align:left; display:none" id="sindy_featured_count_tip">
<?php
_e('Here you can set the number of Featured posts to display on Home page');
 ?>
</div>
</td>
</tr> 

<tr>
 <th scope="row" style="text-align:right; vertical-align:top;">
 <a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility ('sindy_med_featured_tip');">
 <?php _e('Display medium sized image for Featured Posts (Thumbnails will be displayed in Featured Posts Section if this is not checked):')?>
 </td>
 <td>
 <input type="checkbox" name="sindy_med_featured" id="sindy_med_featured" value="true" <?php if ( get_option('sindy_med_featured')) { echo "checked=\"0\""; } else {"";} ?>" />
 <div style="max-width:500px; text-align:left; display:none" id="sindy_med_featured_tip">
 <?php
 _e('Check this if you want to display medium image for featured posts in the theme.But make sure to set the max. width for medium images as 300 in Settings --> Media');
  ?>
 </div>
 </td>
 </tr>
 
 <tr>
 <th scope="row" style="text-align:right; vertical-align:top;">
 <a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility ('sindy_footer_tip');">
 <?php _e('Disable Footer:')?>
 </td>
 <td>
 <input type="checkbox" name="sindy_footer" id="sindy_footer" value="true" <?php if ( get_option('sindy_footer')) { echo "checked=\"0\""; } else {"";} ?>" />
 <div style="max-width:500px; text-align:left; display:none" id="sindy_footer_tip">
 <?php
 _e('Check this if you want to disable Footer in the theme');
  ?>
 </div>
 </td>
 </tr> 
 
 <tr>
 <th scope="row" style="text-align:right; vertical-align:top;">
 <a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility ('sindy_thumbnail');">
 <?php _e('Disable Thumbnail Display:')?>
 </td>
 <td>
 <input type="checkbox" name="sindy_thumbnail" id="sindy_thumbnail" value="true" <?php if ( get_option('sindy_thumbnail')) { echo "checked=\"0\""; } else {"";} ?>" />
 <div style="max-width:500px; text-align:left; display:none" id="sindy_thumbnail">
 <?php
 _e('Check this if you want to disable Thumbnail Display in the theme');
  ?>
 </div>
 </td>
 </tr>
 
</table>
 <p class="submit">
 <input type="hidden" name="action" value="sindy_update" />
 <input type="submit" name="Submit" value="<?php _e('Update Options')?> &raquo;" />
 </p>
 </form>
</div>
<?php

        } // theme admin

add_action('admin_menu', 'theme_add_admin'); 

//register sidebars

if ( function_exists('register_sidebar') ) 
{     
register_sidebar(array('name' => 'Sidebar Left','before_widget' => '<div class="sidebar_box">','after_widget' => '</div>','before_title' => '<h4>','after_title' => '</h4>')); 
register_sidebar(array('name' => 'Sidebar Right','before_widget' => '<div class="sidebar_box">','after_widget' => '</div>','before_title' => '<h4>','after_title' => '</h4>'));   
register_sidebar(array('name' => 'footerleft', 'before_widget' => '','after_widget' => '','before_title' => '<h4>','after_title' => '</h4>'));     
register_sidebar(array('name' => 'footermiddle', 'before_widget' => '','after_widget' => '','before_title' => '<h4>','after_title' => '</h4>'));     
register_sidebar(array('name' => 'footerright', 'before_widget' => '','after_widget' => '','before_title' => '<h4>','after_title' => '</h4>')); 
} 

//Improve the excerpt
function improved_trim_excerpt($text) {
	global $post;
	if ( '' == $text ) {
		$text = get_the_content('');
		$text = apply_filters('the_content', $text);
		$text = str_replace(']]>', ']]&gt;', $text);
		$text = preg_replace('@<script[^>]*?>.*?</script>@si', '', $text);
		$text = strip_tags($text, '<p><a><big><small><em><i><strong>');
		$excerpt_length = 55;
		$words = explode(' ', $text, $excerpt_length + 1);
		if (count($words)> $excerpt_length) {
			array_pop($words);
			array_push($words, '[...]');
			$text = implode(' ', $words);
		}
	}
	return $text;
}

remove_filter('get_the_excerpt', 'wp_trim_excerpt');
add_filter('get_the_excerpt', 'improved_trim_excerpt');

function get_thumbnail($postId) {

    // Get the post ID
    $ID = $postId;//$post->ID;
	
	// Get the thumbnail url for an image hosted elsewhere
	$sThumbUrl = htmlspecialchars(stripcslashes(get_post_meta($ID, 'simpleindy_tn', true)));
	
	if ((!isset($sThumbUrl) && empty($sThumbUrl)) || ($sThumbUrl == "")) {

	    // Get images for this ID
	    $arrImages =& get_children('post_type=attachment&post_mime_type=image&post_parent=' . $ID );

	    // If images exist for this page
	    if($arrImages) {

	        // Get array keys representing attached image numbers
	        $arrKeys = array_keys($arrImages);  
			$post_title = get_the_title($ID);

	        // Get the first image attachment
	        $iNum = $arrKeys[0];

	        // Get the thumbnail url for the attachment
	        $sThumbUrl = wp_get_attachment_thumb_url($iNum);

	        // UNCOMMENT THIS IF YOU WANT THE FULL SIZE IMAGE INSTEAD OF THE THUMBNAIL
	        //$sImageUrl = wp_get_attachment_url($iNum);
			
	    }
	}

	if ($sThumbUrl != "") {
	    // Build the <img> string
	    $sImgString = '<a href="' . get_permalink() . '">' .
	                    '<img src="' . attribute_escape($sThumbUrl) . '" class="left" alt="'.$post_title.'" title="'.$post_title.'" />' .
	                    '</a>';

	    // Print the image
	    echo $sImgString; 
	}
}

function get_medium_img($postId) {

   // Get the post ID
    $ID = $postId;//$post->ID;	
	// Get the medium sized url for an image hosted elsewhere
	$src = htmlspecialchars(stripcslashes(get_post_meta($ID, 'simpleindy_fi', true)));
	
	if ((!isset($src) && empty($src)) || ($src == "")) {

	    // Get images for this ID
	    $arrImages =& get_children('post_type=attachment&post_mime_type=image&post_parent=' . $ID );

	    // If images exist for this page
	    if($arrImages) {

	        // Get array keys representing attached image numbers
	        $arrKeys = array_keys($arrImages);  
			$post_title = get_the_title($ID);

	        // Get the first image attachment
	        $iNum = $arrKeys[0];

	        // Get the thumbnail url for the attachment
	        $image = wp_get_attachment_image_src($iNum, 'medium');		
			if ( $image ) {
				list($src, $width, $height) = $image;			
			}	
		}
	} 
	
	if ($src != "") {
		// Build the <img> string
		$sImgString = '<a href="' . get_permalink() . '">' .
                            '<img src="' . attribute_escape($src) . '" width="300" class="left" alt="'.$post_title.'" title="'.$post_title.'" />' .
                        '</a>';
		// Print the image
		echo $sImgString;
	}
}

add_filter('comments_template', 'legacy_comments');

function legacy_comments($file) {

	if(!function_exists('wp_list_comments')) : // WP 2.7-only check
		$file = TEMPLATEPATH . '/legacycomments.php';
	endif;

	return $file;
}

add_filter('get_comments_number', 'comment_count', 0);
function comment_count( $count ) {
	global $id;
	$comments_for_post = get_comments('post_id=' . $id);
	$comments_by_type = &separate_comments($comments_for_post);
	return count($comments_by_type['comment']);
}

function list_pings($comment, $args, $depth) {
       $GLOBALS['comment'] = $comment; ?>
        <li id="comment-<?php comment_ID(); ?>"><?php comment_author_link(); ?>
<?php } 

function theme_comments ($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?> 
   
   <li <?php comment_class(); ?> id="comment-<?php comment_ID() ?>">
		<div class="clearfloat">
			<?php echo get_avatar( $comment, $size = '55' ); ?>							
			<cite><strong><?php comment_author_link() ?> <?php if($isByAuthor ) { echo '(author)';} ?> </strong> says on: </cite><?php comment_date('j F Y') ?> at <?php comment_time() ?><div class="left commentmetadata"></div>
			<div class="commenttext">
				<?php if ($comment->comment_approved == '0') : ?>
					<em>Your comment is awaiting moderation.</em>
				<?php endif; ?>
				<?php comment_text() ?>
			</div>		
			<div class="right">
				<?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
			</div>
		</div>	
	<?php
}

//Write Panel provision for specifying image urls
function add_simple_indy_img_urls($id) {
	    $awmp_edit = $_POST["simpleindy_edit"];
		$nonce = $_POST['sindy-postform-nonce'];
		if (isset($awmp_edit) && !empty($awmp_edit) && wp_verify_nonce($nonce, 'sindy-postform-nonce')) {	    
		    $ThumbnailURL = $_POST["simpleindy_tn"];
		    $FeaturedImgURL = $_POST["simpleindy_fi"];		    

		    delete_post_meta($id, 'simpleindy_tn');
		    delete_post_meta($id, 'simpleindy_fi');		    

		    if (isset($ThumbnailURL) && !empty($ThumbnailURL)) {
			    add_post_meta($id, 'simpleindy_tn', $ThumbnailURL);
		    }		    
		    if (isset($FeaturedImgURL) && !empty($FeaturedImgURL)) {
			    add_post_meta($id, 'simpleindy_fi', $FeaturedImgURL);
		    }		    
	    }
	}
	
function simple_indy_form_imageURLs() {
	    global $post;
		global $wp_version;
	    $post_id = $post;
	    if (is_object($post_id)) {
	    	$post_id = $post_id->ID;
	    }	    

	    $simpleindy_tn = htmlspecialchars(stripcslashes(get_post_meta($post_id, 'simpleindy_tn', true)));
	    $simpleindy_fi = htmlspecialchars(stripcslashes(get_post_meta($post_id, 'simpleindy_fi', true)));	    
		?>
				
		<?php if ((substr(wp_version, 0, 3) < '2.5')) { ?>
		<div class="dbx-b-ox-wrapper">
		<fieldset id="seodiv" class="dbx-box">
		<div class="dbx-h-andle-wrapper">
		<h3 class="dbx-handle"><?php _e('Simple Indy Theme') ?></h3>
		</div>
		<div class="dbx-c-ontent-wrapper">
		<div class="dbx-content">
		<?php } ?>

		<a target="__blank" href="http://indiafascinates.com/my-first-wordpress-theme-simpleindy/"><?php _e('Click here for Support') ?></a>		
		<input value="simpleindy_edit" type="hidden" name="simpleindy_edit" />
		<input type="hidden" name="sindy-postform-nonce" value="<?php echo wp_create_nonce('sindy-postform-nonce') ?>" />
		<table style="margin-bottom:40px">
		<tr>
		<th style="text-align:left;" colspan="2">
		</th>
		</tr>
		<tr>
		<th scope="row" style="text-align:right;"><?php _e('Thumbnail URL:') ?></th>
		<td><input value="<?php echo $simpleindy_tn ?>" type="text" name="simpleindy_tn" size="62"/></td>
		</tr>		
		<tr>
		<th scope="row" style="text-align:right;"><?php _e('Featured image URL:') ?></th>
		<td><input value="<?php echo $simpleindy_fi ?>" type="text" name="simpleindy_fi" size="62"/></td>
		</tr>		
		</table>		

		<?php if ((substr(wp_version, 0, 3) < '2.5')) { ?>
		</div>
		</fieldset>
		</div>
		<?php } ?>
		<?php  
	}

	function simple_indy_admin_menu() {
		
		if( function_exists( 'add_meta_box' )) {
		    add_meta_box( 'postsimpleindy', __( 'Simple Indy Theme' ), 
		                'simple_indy_form_imageURLs', 'post', 'advanced' );
		    add_meta_box( 'postsimpleindy', __( 'Simple Indy Theme'), 
		                'simple_indy_form_imageURLs', 'page', 'advanced' );
		   } else {
		    add_action('dbx_post_advanced', 'simple_indy_form_imageURLs' );
		    add_action('dbx_page_advanced', 'simple_indy_form_imageURLs' );
		  }
	}
	
	add_action('edit_post', 'add_simple_indy_img_urls');
	add_action('publish_post', 'add_simple_indy_img_urls');
	add_action('save_post', 'add_simple_indy_img_urls');
	add_action('edit_page_form', 'add_simple_indy_img_urls');
	
	add_action('admin_menu', 'simple_indy_admin_menu');

?>