<?php
/**
* Enqueue scripts and styles
*
* @package Simple Grid WordPress Theme
* @copyright Copyright (C) 2025 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/

function simple_grid_scripts() {
    wp_enqueue_style('simple-grid-maincss', get_stylesheet_uri(), array(), null);
    wp_enqueue_style('fontawesome', get_template_directory_uri() . '/assets/css/all.min.css', array(), null );
    wp_enqueue_style('simple-grid-webfont', '//fonts.googleapis.com/css?family=Playfair+Display:400,400i,700,700i|Domine:400,700|Oswald:400,700|Patua+One|Merriweather:400,400i,700,700i&amp;display=swap', array(), null);

    $simple_grid_fitvids_active = false;
    if ( simple_grid_is_fitvids_active() ) {
        $simple_grid_fitvids_active = true;
    }
    if ( $simple_grid_fitvids_active ) {
        wp_enqueue_script('fitvids', get_template_directory_uri() .'/assets/js/jquery.fitvids.min.js', array( 'jquery' ), null, true);
    }

    $simple_grid_primary_mobile_menu_active = true;
    $simple_grid_secondary_mobile_menu_active = true;

    $simple_grid_primary_menu_active = false;
    if ( simple_grid_is_primary_menu_active() ) {
        $simple_grid_primary_menu_active = true;
    }
    $simple_grid_secondary_menu_active = false;
    if ( simple_grid_is_secondary_menu_active() ) {
        $simple_grid_secondary_menu_active = true;
    }

    $simple_grid_sticky_menu_active = true;
    $simple_grid_sticky_mobile_menu_active = false;

    $simple_grid_sticky_sidebar_active = true;
    if ( is_singular() ) {
        if ( is_page_template( array( 'template-full-width-page.php', 'template-full-width-post.php' ) ) ) {
           $simple_grid_sticky_sidebar_active = false;
        }
    } else {
        $simple_grid_sticky_sidebar_active = false;
    }
    if ( $simple_grid_sticky_sidebar_active ) {
        wp_enqueue_script('ResizeSensor', get_template_directory_uri() .'/assets/js/ResizeSensor.min.js', array( 'jquery' ), null, true);
        wp_enqueue_script('theia-sticky-sidebar', get_template_directory_uri() .'/assets/js/theia-sticky-sidebar.min.js', array( 'jquery' ), null, true);
    }

    $simple_grid_columnwidth = '.simple-grid-5-col-sizer';
    $simple_grid_gutter = '.simple-grid-5-col-gutter';

    wp_enqueue_script('simple-grid-navigation', get_template_directory_uri() . '/assets/js/navigation.js', array(), null, true );
    wp_enqueue_script('simple-grid-skip-link-focus-fix', get_template_directory_uri() . '/assets/js/skip-link-focus-fix.js', array(), null, true );
    wp_enqueue_script('simple-grid-customjs', get_template_directory_uri() .'/assets/js/custom.js', array( 'jquery', 'imagesloaded' ), null, true);

    wp_localize_script( 'simple-grid-customjs', 'simple_grid_ajax_object',
        array(
            'ajaxurl' => esc_url_raw( admin_url( 'admin-ajax.php' ) ),
            'primary_menu_active' => $simple_grid_primary_menu_active,
            'secondary_menu_active' => $simple_grid_secondary_menu_active,
            'primary_mobile_menu_active' => $simple_grid_primary_mobile_menu_active,
            'secondary_mobile_menu_active' => $simple_grid_secondary_mobile_menu_active,
            'sticky_menu_active' => $simple_grid_sticky_menu_active,
            'sticky_mobile_menu_active' => $simple_grid_sticky_mobile_menu_active,
            'sticky_sidebar_active' => $simple_grid_sticky_sidebar_active,
            'fitvids_active' => $simple_grid_fitvids_active,
            'columnwidth' => $simple_grid_columnwidth,
            'gutter' => $simple_grid_gutter,
        )
    );

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}
add_action( 'wp_enqueue_scripts', 'simple_grid_scripts' );

/**
 * Enqueue customizer styles.
 */
function simple_grid_enqueue_customizer_styles() {
    wp_enqueue_style( 'simple-grid-customizer-styles', get_template_directory_uri() . '/inc/admin/css/customizer-style.css', array(), null );
    wp_enqueue_style('fontawesome', get_template_directory_uri() . '/assets/css/all.min.css', array(), null );
}
add_action( 'customize_controls_enqueue_scripts', 'simple_grid_enqueue_customizer_styles' );