<?php
/**
 * Add Portfolio Settings in Customizer
 *
 * @package Shutter_Up
 */

/**
 * Add portfolio options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function shutter_up_portfolio_options( $wp_customize ) {
	// Add note to Jetpack Portfolio Section
	shutter_up_register_option( $wp_customize, array(
			'name'              => 'shutter_up_jetpack_portfolio_cpt_note',
			'sanitize_callback' => 'sanitize_text_field',
			'custom_control'    => 'Shutter_Up_Note_Control',
			'label'             => sprintf( esc_html__( 'For Portfolio Options for Shutter Up Theme, go %1$shere%2$s', 'shutter-up' ),
				 '<a href="javascript:wp.customize.section( \'shutter_up_portfolio\' ).focus();">',
				 '</a>'
			),
			'section'           => 'jetpack_portfolio',
			'type'              => 'description',
			'priority'          => 1,
		)
	);

	$wp_customize->add_section( 'shutter_up_portfolio', array(
			'panel'    => 'shutter_up_theme_options',
			'title'    => esc_html__( 'Portfolio', 'shutter-up' ),
		)
	);

	$action = 'install-plugin';
	$slug   = 'essential-content-types';

	$install_url = wp_nonce_url(
	    add_query_arg(
	        array(
	            'action' => $action,
	            'plugin' => $slug
	        ),
	        admin_url( 'update.php' )
	    ),
	    $action . '_' . $slug
	);

	shutter_up_register_option( $wp_customize, array(
	        'name'              => 'shutter_up_portfolio_jetpack_note',
	        'sanitize_callback' => 'sanitize_text_field',
	        'custom_control'    => 'Shutter_Up_Note_Control',
	        'active_callback'   => 'shutter_up_is_ect_portfolio_inactive',
	        /* translators: 1: <a>/link tag start, 2: </a>/link tag close. */
	        'label'             => sprintf( esc_html__( 'For Portfolio, install %1$sEssential Content Types%2$s Plugin with Portfolio Type Enabled', 'shutter-up' ),
	            '<a target="_blank" href="' . esc_url( $install_url ) . '">',
	            '</a>'

	        ),
	       'section'            => 'shutter_up_portfolio',
	        'type'              => 'description',
	        'priority'          => 1,
	    )
	);

	shutter_up_register_option( $wp_customize, array(
			'name'              => 'shutter_up_portfolio_option',
			'default'           => 'disabled',
			'sanitize_callback' => 'shutter_up_sanitize_select',
			'active_callback'   => 'shutter_up_is_ect_portfolio_active',
			'choices'           => shutter_up_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'shutter-up' ),
			'section'           => 'shutter_up_portfolio',
			'type'              => 'select',
		)
	);

	shutter_up_register_option( $wp_customize, array(
			'name'              => 'shutter_up_portfolio_cpt_note',
			'sanitize_callback' => 'sanitize_text_field',
			'custom_control'    => 'Shutter_Up_Note_Control',
			'active_callback'   => 'shutter_up_is_portfolio_active',
			'label'             => sprintf( esc_html__( 'For CPT heading and sub-heading, go %1$shere%2$s', 'shutter-up' ),
				 '<a href="javascript:wp.customize.control( \'jetpack_portfolio_title\' ).focus();">',
				 '</a>'
			),
			'section'           => 'shutter_up_portfolio',
			'type'              => 'description',
		)
	);

	shutter_up_register_option( $wp_customize, array(
			'name'              => 'shutter_up_portfolio_number',
			'default'           => 6,
			'sanitize_callback' => 'shutter_up_sanitize_number_range',
			'active_callback'   => 'shutter_up_is_portfolio_active',
			'label'             => esc_html__( 'Number of items to show', 'shutter-up' ),
			'section'           => 'shutter_up_portfolio',
			'type'              => 'number',
			'input_attrs'       => array(
				'style'             => 'width: 100px;',
				'min'               => 0,
			),
		)
	);

	$number = get_theme_mod( 'shutter_up_portfolio_number', 6 );

	for ( $i = 1; $i <= $number ; $i++ ) {

		//for CPT
		shutter_up_register_option( $wp_customize, array(
				'name'              => 'shutter_up_portfolio_cpt_' . $i,
				'sanitize_callback' => 'shutter_up_sanitize_post',
				'active_callback'   => 'shutter_up_is_portfolio_active',
				'label'             => esc_html__( 'Portfolio', 'shutter-up' ) . ' ' . $i ,
				'section'           => 'shutter_up_portfolio',
				'type'              => 'select',
				'choices'           => shutter_up_generate_post_array( 'jetpack-portfolio' ),
			)
		);

	} // End for().

	shutter_up_register_option( $wp_customize, array(
			'name'              => 'shutter_up_portfolio_text',
			'default'           => esc_html__( 'View More', 'shutter-up' ),
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'shutter_up_is_portfolio_active',
			'label'             => esc_html__( 'Button Text', 'shutter-up' ),
			'section'           => 'shutter_up_portfolio',
			'type'              => 'text',
		)
	);

	shutter_up_register_option( $wp_customize, array(
			'name'              => 'shutter_up_portfolio_link',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'shutter_up_is_portfolio_active',
			'label'             => esc_html__( 'Button Link', 'shutter-up' ),
			'section'           => 'shutter_up_portfolio',
		)
	);

	shutter_up_register_option( $wp_customize, array(
			'name'              => 'shutter_up_portfolio_target',
			'sanitize_callback' => 'shutter_up_sanitize_checkbox',
			'active_callback'   => 'shutter_up_is_portfolio_active',
			'label'             => esc_html__( 'Open Link in New Window/Tab', 'shutter-up' ),
			'section'           => 'shutter_up_portfolio',
			'custom_control'    => 'Shutter_Up_Toggle_Control',
		)
	);
}
add_action( 'customize_register', 'shutter_up_portfolio_options' );

/**
 * Active Callback Functions
 */
if ( ! function_exists( 'shutter_up_is_portfolio_active' ) ) :
	/**
	* Return true if portfolio is active
	*
	* @since Shutter Up 1.0
	*/
	function shutter_up_is_portfolio_active( $control ) {
		$enable = $control->manager->get_setting( 'shutter_up_portfolio_option' )->value();

        //return true only if previwed page on customizer matches the type of content option selected
        return ( shutter_up_is_ect_portfolio_active( $control ) &&  shutter_up_check_section( $enable ) );
	}
endif;

if ( ! function_exists( 'shutter_up_is_ect_portfolio_inactive' ) ) :
    /**
    *
    * @since Shutter Up 1.0
    */
    function shutter_up_is_ect_portfolio_inactive( $control ) {
        return ! ( class_exists( 'Essential_Content_Jetpack_Portfolio' ) || class_exists( 'Essential_Content_Pro_Jetpack_Portfolio' ) );
    }
endif;

if ( ! function_exists( 'shutter_up_is_ect_portfolio_active' ) ) :
    /**
    *
    * @since Shutter Up 1.0
    */
    function shutter_up_is_ect_portfolio_active( $control ) {
        return ( class_exists( 'Essential_Content_Jetpack_Portfolio' ) || class_exists( 'Essential_Content_Pro_Jetpack_Portfolio' ) );
    }
endif;

