<?php
/**
 * Displays mobile navigation
 *
 * @package Short News
 * @since Short News 1.1.2
 */

?>

<nav id="mobile-navigation" [class]="ampmenu ? 'main-navigation mobile-navigation active' : 'main-navigation mobile-navigation'" class="main-navigation mobile-navigation" aria-label="<?php esc_attr_e( 'Mobile Menu', 'short-news' ); ?>">
	<div class="mobile-navigation-wrapper">
		<?php
		wp_nav_menu( array(
			'theme_location'        => 'main_menu',
			'menu_id'               => 'mobile-menu',
			'menu_class'            => 'mobile-menu',
			'show_sub_menu_toggles' => true,
			'container'             => false,
			'fallback_cb'           => 'short_news_fallback_menu'
		) );
		if ( has_nav_menu( 'social_menu' ) ) {
			wp_nav_menu( array(
				'theme_location'  => 'social_menu',
				'container'       => false,
				'menu_class'      => 'social-menu',
				'depth'           => 1,
				'link_before'     => '<span class="screen-reader-text">',
				'link_after'      => '</span>',
				'fallback_cb'     => '',
			) );
		}
		?>
	</div>
</nav>
