/**
 * File script.js.
 *
 */

( function() {

	function toggleMenu() {
		const button = document.getElementById( 'menu-toggle' );
		if (!button) {
			return;
		}

		const mobileNav  = document.getElementById( 'mobile-navigation' );
		const mobileMenu = mobileNav.querySelector( 'ul' );
		const body       = document.body;
		
		button.addEventListener( 'click', () => {
			if ( mobileNav.classList.contains( 'active' ) ) {
				button.setAttribute( 'aria-expanded', 'false' );
				mobileMenu.setAttribute( 'aria-expanded', 'false' );
			} else {
				button.setAttribute( 'aria-expanded', 'true' );
				mobileMenu.setAttribute( 'aria-expanded', 'true' );
			}
			mobileNav.classList.toggle( 'active' );
			body.classList.toggle( 'mobile-nav-open' );
		} );
	}

	function toggleSubmenu() {
		const mobileNav = document.getElementById( 'mobile-navigation' );
		if (!mobileNav) {
			return;
		}

		const buttons = [...mobileNav.querySelectorAll( '.dropdown-toggle' )];

		buttons.forEach( button => {
			button.addEventListener( 'click', e => {
				e.preventDefault();
				const a = button.previousElementSibling, li = a.closest( 'li' );
				if ( li.classList.contains( 'is-open' ) ) {
					button.setAttribute( 'aria-expanded', 'false' );
					a.setAttribute( 'aria-expanded', 'false' );
				} else {
					button.setAttribute( 'aria-expanded', 'true' );
					a.setAttribute( 'aria-expanded', 'true' );
				}
				li.classList.toggle( 'is-open' );
			} );
		} );
	}

	function toggleSearch() {
		const searchPopups = document.querySelectorAll( '.search-popup' );
		if (!searchPopups) {
			return;
		}

		searchPopups.forEach( searchPopup => {
			const searchButton     = searchPopup.querySelector( '.search-popup .search-popup-button');
			const searchInputField = searchPopup.querySelector( '.search-popup .search-field');
			searchButton.addEventListener( 'click', e => {
				if ( searchPopup.classList.contains( 'active' ) ) {
					searchButton.setAttribute( 'aria-expanded', 'false' );
					searchButton.focus();
				} else {
					searchButton.setAttribute( 'aria-expanded', 'true' );
					searchInputField.focus();
				}
				searchPopup.classList.toggle( 'active' );
			} );
		} );
	}

	function scrollToTop() {
		const button = document.getElementById( 'scroll-up' );
		if (!button) {
			return;
		}

		window.addEventListener( 'scroll', () => {
			if ( window.scrollY > 480 ) {
				button.classList.add( 'is-visible' );
			} else {
				button.classList.remove( 'is-visible' );
			}
		} );

		button.addEventListener( 'click', e => {
			e.preventDefault();
			window.scrollTo( { top: 0, left: 0, behavior: 'smooth' } );
		} );
	}

	toggleMenu();
	toggleSubmenu();
	toggleSearch();
	scrollToTop();

}() );
