<?php
/**
 * Add additional wooCommerce settings section and it's fields inside General section group.
 * 
 * @package Shopay
 */

add_action( 'customize_register', 'shopay_woocommerce_setting_fields' );

if ( ! function_exists( 'shopay_woocommerce_setting_fields' ) ) {

	/**
     * Register additional wooCommerce settings section's fields.
     */
	function shopay_woocommerce_setting_fields( $wp_customize ) {

        if ( shopay_is_active_woocommerce() ){
		/**
         * Additional Settings Section
         *
         * Theme Options > General > WooCommerce 
         * @since 1.0.0
         */
        $wp_customize->add_section( new Shopay_Customize_Section(
            $wp_customize, 'shopay_section_woocommerce_settings',
                array(
                    'priority'      => 30,
                    'panel'         => 'shopay_theme_options_panel',
                    'section'       => 'shopay_general_group',
                    'capability'    => 'edit_theme_options',
                    'theme_options' => '',
                    'title'         => __( 'wooCommerce', 'shopay' )
                )
            )
        );
         /**
         * Toggle option for woo cart link
         *
         * Theme Options > General > WooCommerce 
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'shopay_cart_link_option',
            array(
                'capability'        => 'edit_theme_options',
                'theme_options'     => '',
                'default'           => false,
                'sanitize_callback' => 'shopay_sanitize_checkbox'
            )
        );

        $wp_customize->add_control( new Shopay_Control_Toggle(
            $wp_customize, 'shopay_cart_link_option',
                array(
                    'priority'          => 5,
                    'section'           => 'shopay_section_woocommerce_settings',
                    'settings'          => 'shopay_cart_link_option',
                    'label'             => __( 'Enable Woo Cart', 'shopay' ),
                    'active_callback'   => 'shopay_is_woo_acitvated_active_callback',
                )
            )
        );
        if ( shopay_is_active_wishlist() ) {
        /**
         * Toggle option for yith wishlist
         *
         * Theme Options > General > WooCommerce 
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'shopay_wishlist_link_option',
            array(
                'capability'        => 'edit_theme_options',
                'theme_options'     => '',
                'default'           => false,
                'sanitize_callback' => 'shopay_sanitize_checkbox'
            )
        );

        $wp_customize->add_control( new Shopay_Control_Toggle(
            $wp_customize, 'shopay_wishlist_link_option',
                array(
                    'priority'          => 10,
                    'section'           => 'shopay_section_woocommerce_settings',
                    'settings'          => 'shopay_wishlist_link_option',
                    'label'             => __( 'Enable Yith Wishlist', 'shopay' ),
                    'active_callback'   => 'shopay_yith_active_callback',
                )
            )
        );
         /**
         * option for add to wishlist text
         *
         * Theme Options > General > WooCommerce 
         * @since 1.2.1
         */

        $wp_customize->add_setting( 'shopay_add_to_wishlist_text',
            array(
                'default'           => __( 'Add To Wishlist', 'shopay' ),
                'theme_options'     => '',
                'capability'        => 'edit_theme_options',
                'transport'         => 'postMessage',
                'sanitize_callback' =>'shopay_sanitize_textarea_field'
            )

        );

        $wp_customize->add_control( 'shopay_add_to_wishlist_text',
            array(
                'priority' =>  20,
                'section'  => 'shopay_section_woocommerce_settings',
                'settings' => 'shopay_add_to_wishlist_text',
                'label'    => __( 'Add to Wishlist Label', 'shopay' ),
                'type'     => 'text'
            )

        );
    }
         /**
         * option for add to cart text
         *
         * Theme Options > General > WooCommerce 
         * @since 1.2.1
         */

		$wp_customize->add_setting( 'shopay_add_to_cart_text',
            array(
                'default'           => __( 'Add To Cart', 'shopay' ),
                'theme_options'     => '',
                'capability'        => 'edit_theme_options',
                'transport'         => 'postMessage',
                'sanitize_callback' =>'shopay_sanitize_textarea_field'
            )

    	);

        $wp_customize->add_control( 'shopay_add_to_cart_text',
            array(
                'priority' =>  15,
                'section'  => 'shopay_section_woocommerce_settings',
                'settings' => 'shopay_add_to_cart_text',
                'label'    => __( 'Add to Cart Label', 'shopay' ),
                'type'     => 'text'
            )

        );
       

         /**
         * Toggle option for showing category in product loop
         *
         * Theme Options > General > WooCommerce 
         * @since 1.2.1
         */
        $wp_customize->add_setting( 'shopay_show_product_category',
            array(
                'capability'        => 'edit_theme_options',
                'theme_options'     => '',
                'default'           => false,
                'sanitize_callback' => 'shopay_sanitize_checkbox'
            )
        );

        $wp_customize->add_control( new Shopay_Control_Toggle(
            $wp_customize, 'shopay_show_product_category',
                array(
                    'priority'      => 25,
                    'section'       => 'shopay_section_woocommerce_settings',
                    'settings'      => 'shopay_show_product_category',
                    'label'         => __( 'Enable Product Category', 'shopay' )
                )
            )
        );
        /**
         * Upgrade field
         *  
         */ 
        $wp_customize->add_setting( 'shopay_upgrade_woocommerce',
            array(
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new Shopay_Control_Upgrade(
            $wp_customize, 'shopay_upgrade_woocommerce',
                array(
                    'label'         => __( 'More Features', 'shopay' ),
                    'description'   => __( 'Upgrade to pro for wooCommerce advanced settings.', 'shopay' ),
                    'section'       => 'shopay_section_woocommerce_settings',
                    'settings'      => 'shopay_upgrade_woocommerce',
                    'url'           => esc_url( 'https://mysterythemes.com/pricing/?product_id=5950' ),
                    'priority'      => 50,
                )
            )
        );
       }
	}

}

