<?php
/**
 * Customizer Theme UPsell Section.
 * 
 * @package Shopay
*/

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( class_exists( 'WP_Customize_Section' ) ) {

/*-----------------------------------------------------------------------------------------------------------------------*/
    
    /**
     * Upsell customizer section.
     *
     * @since  1.0.7
     * @access public
     */
    class Shopay_Section_Upsell extends WP_Customize_Section {

        /**
         * The type of customize section being rendered.
         *
         * @since  1.0.0
         * @access public
         * @var    string
         */
        public $type = 'mt-upsell';

        /**
         * Custom button text to output.
         *
         * @since  1.0.0
         * @access public
         * @var    string
         */
        public $pro_text = '';

        /**
         * Custom pro button URL.
         *
         * @since  1.0.0
         * @access public
         * @var    string
         */
        public $pro_url = '';

        /**
         * Add custom parameters to pass to the JS via JSON.
         *
         * @since  1.0.0
         * @access public
         * @return void
         */
        public function json() {
            $json = parent::json();

            $json['pro_text'] = $this->pro_text;
            $json['pro_url']  = esc_url( $this->pro_url );

            return $json;
        }

        /**
         * Outputs the Underscore.js template.
         *
         * @since  1.0.0
         * @access public
         * @return void
         */
        protected function render_template() { ?>

            <li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }} cannot-expand">
                <h3 class="accordion-section-title">
                    {{ data.title }}

                    <# if ( data.pro_text && data.pro_url ) { #>
                        <a href="{{ data.pro_url }}" class="button button-secondary alignright" target="_blank">{{ data.pro_text }}</a>
                    <# } #>
                </h3>
            </li>
        <?php }
    }
    /*--------------------------------------- Upgrade Control ------------------------------------------------ */

        if ( ! class_exists( 'Shopay_Control_Upgrade' ) ) {

            /**
             * Upgrade control
             */
            class Shopay_Control_Upgrade extends WP_Customize_Control {
                
                /**
                 * The control type.
                 *
                 * @access public
                 * @var string
                 */
                public $type = 'mt-upgrade';
                
                /**
                 * Custom links for this control.
                 *
                 * @access public
                 * @var array
                 */
                public $url = '';
                
                /**
                 * Refresh the parameters passed to the JavaScript via JSON.
                 *
                 * @see WP_Customize_Control::to_json()
                 */
                public function to_json() {
                    parent::to_json();
                    
                    if ( isset( $this->default ) ) {
                        $this->json['default'] = $this->default;
                    } else{
                        $this->json['default'] = $this->setting->default;
                    }
                    
                    $this->json['url'] = esc_url( $this->url );
                }
                
                protected function content_template() {
                    ?>
                        <# if ( data.label ) { #>
                            <span class="customize-control-title upgrade-title"><i class="dashicons dashicons-info"></i>{{{ data.label }}}</span>
                        <# } #>
                        <# if ( data.description ) { #>
                            <span class="description customize-control-description upgrade-description">{{{ data.description }}}</span>
                        <# } #>
                        <# if ( data.url ) { #>
                            <a class="mt-upgrade-btn" href="{{{ data.url }}}" target="_blank"><?php esc_html_e( 'upgrade to pro', 'shopay' ); ?></a>
                        <# } #>
                    <?php
                }
            }

        } //Ends Shopay_Control_Upgrade
    
}