;(function($){
	$(document).ready(function(){
		// Existing click handler for dismiss button
		$('.btnend').on('click',function(){
			var url = new URL(location.href);
			url.searchParams.append('xbnotice',1);
			// Add nonce for security (if available in global JS vars)
			if (typeof shopToolkitNotice !== 'undefined' && shopToolkitNotice.nonce) {
				url.searchParams.append('_wpnonce', shopToolkitNotice.nonce);
			}
			location.href= url;
		});
		
		// Add hover effects to buttons
		$('.upgrade-primary, .demo-btn').hover(
			function() {
				$(this).addClass('button-hover');
			},
			function() {
				$(this).removeClass('button-hover');
			}
		);
		
		// Add animation to feature items on hover
		$('.feature-item').hover(
			function() {
				$(this).css('transform', 'translateY(-3px)');
			},
			function() {
				$(this).css('transform', 'translateY(0)');
			}
		);
		
		// Add subtle animation to the hero section
		$('.mgadin-hero').hover(
			function() {
				$(this).find('.mge-info-hello').css('transform', 'scale(1.05)');
			},
			function() {
				$(this).find('.mge-info-hello').css('transform', 'scale(1)');
			}
		);
	});
})(jQuery);