/**
 * WooCommerce AJAX Debug Script
 * Remove this file after debugging is complete
 */
(function($) {
    'use strict';

    console.log('[WC Debug] Script loaded');

    // Check if jQuery is available
    if (typeof jQuery === 'undefined') {
        console.error('[WC Debug] jQuery is NOT loaded!');
        return;
    }
    console.log('[WC Debug] jQuery version:', $.fn.jquery);

    // Check WooCommerce params
    if (typeof wc_add_to_cart_params !== 'undefined') {
        console.log('[WC Debug] wc_add_to_cart_params found:', wc_add_to_cart_params);
    } else {
        console.error('[WC Debug] wc_add_to_cart_params is NOT defined!');
    }

    // Check cart fragment params
    if (typeof wc_cart_fragments_params !== 'undefined') {
        console.log('[WC Debug] wc_cart_fragments_params found:', wc_cart_fragments_params);
    } else {
        console.warn('[WC Debug] wc_cart_fragments_params is NOT defined (may load later)');
    }

    $(document).ready(function() {
        console.log('[WC Debug] Document ready');

        // Check for add to cart buttons
        var addToCartButtons = $('.ajax_add_to_cart');
        console.log('[WC Debug] Found ' + addToCartButtons.length + ' ajax_add_to_cart buttons');

        // Check for cart widget
        var cartWidget = $('.widget_shopping_cart_content');
        console.log('[WC Debug] Cart widget found:', cartWidget.length > 0);

        // Check body class
        var hasWcJs = $('body').hasClass('woocommerce-js');
        var hasWcNoJs = $('body').hasClass('woocommerce-no-js');
        console.log('[WC Debug] body has woocommerce-js:', hasWcJs);
        console.log('[WC Debug] body has woocommerce-no-js:', hasWcNoJs);

        // Listen for WooCommerce events
        $(document.body).on('adding_to_cart', function(e, button, data) {
            console.log('[WC Debug] EVENT: adding_to_cart', { button: button, data: data });
        });

        $(document.body).on('added_to_cart', function(e, fragments, cart_hash, button) {
            console.log('[WC Debug] EVENT: added_to_cart', { fragments: fragments, cart_hash: cart_hash, button: button });
        });

        $(document.body).on('removed_from_cart', function(e, fragments, cart_hash, button) {
            console.log('[WC Debug] EVENT: removed_from_cart');
        });

        $(document.body).on('wc_cart_button_updated', function(e, button) {
            console.log('[WC Debug] EVENT: wc_cart_button_updated');
        });

        $(document.body).on('cart_page_refreshed', function() {
            console.log('[WC Debug] EVENT: cart_page_refreshed');
        });

        $(document.body).on('cart_totals_refreshed', function() {
            console.log('[WC Debug] EVENT: cart_totals_refreshed');
        });

        $(document.body).on('wc_fragments_refreshed', function() {
            console.log('[WC Debug] EVENT: wc_fragments_refreshed');
        });

        $(document.body).on('wc_fragments_loaded', function() {
            console.log('[WC Debug] EVENT: wc_fragments_loaded');
        });

        // Monitor AJAX requests
        $(document).ajaxSend(function(event, jqXHR, settings) {
            if (settings.url && settings.url.indexOf('wc-ajax') !== -1) {
                console.log('[WC Debug] AJAX Request:', settings.url, settings.data);
            }
        });

        $(document).ajaxComplete(function(event, jqXHR, settings) {
            if (settings.url && settings.url.indexOf('wc-ajax') !== -1) {
                console.log('[WC Debug] AJAX Complete:', settings.url, 'Status:', jqXHR.status);
                try {
                    var response = JSON.parse(jqXHR.responseText);
                    console.log('[WC Debug] AJAX Response:', response);
                } catch(e) {
                    console.log('[WC Debug] AJAX Response (raw):', jqXHR.responseText);
                }
            }
        });

        $(document).ajaxError(function(event, jqXHR, settings, error) {
            if (settings.url && settings.url.indexOf('wc-ajax') !== -1) {
                console.error('[WC Debug] AJAX Error:', error);
            }
        });

        // Manual test function
        window.testWooCommerceAjax = function() {
            console.log('[WC Debug] Manual test initiated');
            
            var firstButton = $('.ajax_add_to_cart').first();
            if (firstButton.length) {
                console.log('[WC Debug] Clicking first add to cart button');
                firstButton.trigger('click');
            } else {
                console.error('[WC Debug] No add to cart button found');
            }
        };

        console.log('[WC Debug] To manually test, run: testWooCommerceAjax()');
    });

    // Check after window load (when all scripts should be loaded)
    $(window).on('load', function() {
        console.log('[WC Debug] Window load complete');
        
        // Re-check wc_cart_fragments_params
        if (typeof wc_cart_fragments_params !== 'undefined') {
            console.log('[WC Debug] wc_cart_fragments_params (on load):', wc_cart_fragments_params);
        } else {
            console.error('[WC Debug] wc_cart_fragments_params still NOT defined after load!');
        }

        // Check body class again
        var hasWcJs = $('body').hasClass('woocommerce-js');
        console.log('[WC Debug] body has woocommerce-js (on load):', hasWcJs);
    });

})(jQuery);
