<?php
/**
 * Adore Themes Customizer
 *
 * @package Shining Blog
 *
 * Featured Posts Section
 */

$wp_customize->add_section(
	'shining_blog_featured_posts_section',
	array(
		'title'    => esc_html__( 'Featured Posts Section', 'shining-blog' ),
		'panel'    => 'glowing_blog_frontpage_panel',
		'priority' => 30,
	)
);

// Featured Posts section enable settings.
$wp_customize->add_setting(
	'shining_blog_featured_posts_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'glowing_blog_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Shining_Blog_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'shining_blog_featured_posts_section_enable',
		array(
			'label'    => esc_html__( 'Enable Featured Posts Section', 'shining-blog' ),
			'type'     => 'checkbox',
			'settings' => 'shining_blog_featured_posts_section_enable',
			'section'  => 'shining_blog_featured_posts_section',
		)
	)
);

// Featured Posts title settings.
$wp_customize->add_setting(
	'shining_blog_featured_posts_title',
	array(
		'default'           => __( 'Featured Posts', 'shining-blog' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'shining_blog_featured_posts_title',
	array(
		'label'           => esc_html__( 'Section Title', 'shining-blog' ),
		'section'         => 'shining_blog_featured_posts_section',
		'active_callback' => 'shining_blog_if_featured_posts_enabled',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'shining_blog_featured_posts_title',
		array(
			'selector'            => '.featured-grid-section h3.section-title',
			'settings'            => 'shining_blog_featured_posts_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'shining_blog_featured_posts_title_text_partial',
		)
	);
}

// Featured Posts subtitle settings.
$wp_customize->add_setting(
	'shining_blog_featured_posts_subtitle',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'shining_blog_featured_posts_subtitle',
	array(
		'label'           => esc_html__( 'Section Subtitle', 'shining-blog' ),
		'section'         => 'shining_blog_featured_posts_section',
		'active_callback' => 'shining_blog_if_featured_posts_enabled',
	)
);

// Featured Posts content type settings.
$wp_customize->add_setting(
	'shining_blog_featured_posts_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'glowing_blog_sanitize_select',
	)
);

$wp_customize->add_control(
	'shining_blog_featured_posts_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'shining-blog' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'shining-blog' ),
		'section'         => 'shining_blog_featured_posts_section',
		'type'            => 'select',
		'active_callback' => 'shining_blog_if_featured_posts_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'shining-blog' ),
			'category' => esc_html__( 'Category', 'shining-blog' ),
		),
	)
);

for ( $i = 1; $i <= 4; $i++ ) {
	// Featured Posts post setting.
	$wp_customize->add_setting(
		'shining_blog_featured_posts_post_' . $i,
		array(
			'sanitize_callback' => 'glowing_blog_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'shining_blog_featured_posts_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'shining-blog' ), $i ),
			'section'         => 'shining_blog_featured_posts_section',
			'type'            => 'select',
			'choices'         => glowing_blog_get_post_choices(),
			'active_callback' => 'shining_blog_featured_posts_section_content_type_post_enabled',
		)
	);

}

// Featured Posts category setting.
$wp_customize->add_setting(
	'shining_blog_featured_posts_category',
	array(
		'sanitize_callback' => 'glowing_blog_sanitize_select',
	)
);

$wp_customize->add_control(
	'shining_blog_featured_posts_category',
	array(
		'label'           => esc_html__( 'Category', 'shining-blog' ),
		'section'         => 'shining_blog_featured_posts_section',
		'type'            => 'select',
		'choices'         => glowing_blog_get_post_cat_choices(),
		'active_callback' => 'shining_blog_featured_posts_section_content_type_category_enabled',
	)
);

// Featured Posts view all button label setting.
$wp_customize->add_setting(
	'shining_blog_featured_posts_viewall_button_label',
	array(
		'default'           => __( 'View All', 'shining-blog' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'shining_blog_featured_posts_viewall_button_label',
	array(
		'label'           => esc_html__( 'Button Label', 'shining-blog' ),
		'section'         => 'shining_blog_featured_posts_section',
		'type'            => 'text',
		'active_callback' => 'shining_blog_if_featured_posts_enabled',
	)
);

// Featured Posts view all button url setting.
$wp_customize->add_setting(
	'shining_blog_featured_posts_viewall_button_url',
	array(
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'shining_blog_featured_posts_viewall_button_url',
	array(
		'label'           => esc_html__( 'View All Button Link', 'shining-blog' ),
		'section'         => 'shining_blog_featured_posts_section',
		'settings'        => 'shining_blog_featured_posts_viewall_button_url',
		'type'            => 'url',
		'active_callback' => 'shining_blog_if_featured_posts_enabled',
	)
);

/*========================Active Callback==============================*/
function shining_blog_if_featured_posts_enabled( $control ) {
	return $control->manager->get_setting( 'shining_blog_featured_posts_section_enable' )->value();
}
function shining_blog_featured_posts_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'shining_blog_featured_posts_content_type' )->value();
	return shining_blog_if_featured_posts_enabled( $control ) && ( 'post' === $content_type );
}
function shining_blog_featured_posts_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'shining_blog_featured_posts_content_type' )->value();
	return shining_blog_if_featured_posts_enabled( $control ) && ( 'category' === $content_type );
}

/*========================Partial Refresh==============================*/
if ( ! function_exists( 'shining_blog_featured_posts_title_text_partial' ) ) :
	// Title.
	function shining_blog_featured_posts_title_text_partial() {
		return esc_html( get_theme_mod( 'shining_blog_featured_posts_title' ) );
	}
endif;
