<?php

// upgrade to pro.
require get_theme_file_path() . '/inc/upgrade-to-pro/class-customize.php';

function shining_blog_customize_register( $wp_customize ) {

	class Shining_Blog_Toggle_Checkbox_Custom_control extends WP_Customize_Control {
		public $type = 'toogle_checkbox';

		public function render_content() {
			?>
			<div class="checkbox_switch">
				<div class="onoffswitch">
					<input type="checkbox" id="<?php echo esc_attr( $this->id ); ?>" name="<?php echo esc_attr( $this->id ); ?>" class="onoffswitch-checkbox" value="<?php echo esc_attr( $this->value() ); ?>" 
					<?php
					$this->link();
					checked( $this->value() );
					?>
					>
					<label class="onoffswitch-label" for="<?php echo esc_attr( $this->id ); ?>"></label>
				</div>
				<span class="customize-control-title onoffswitch_label"><?php echo esc_html( $this->label ); ?></span>
				<p><?php echo wp_kses_post( $this->description ); ?></p>
			</div>
			<?php
		}
	}

	// Posts carousel section.
	require get_theme_file_path() . '/inc/customizer/featured-posts.php';

	// List layout options.
	$wp_customize->add_setting(
		'shining_blog_archive_list_layout_styles',
		array(
			'default'           => 'list-style-1',
			'sanitize_callback' => 'glowing_blog_sanitize_select',
		)
	);

	$wp_customize->add_control(
		'shining_blog_archive_list_layout_styles',
		array(
			'label'           => esc_html__( 'List Layout Styles', 'shining-blog' ),
			'section'         => 'glowing_blog_archive_page_options',
			'type'            => 'select',
			'choices'         => array(
				'list-style-1' => __( 'List Style 1', 'shining-blog' ),
				'list-style-3' => __( 'List Style 2', 'shining-blog' ),
			),
			'priority' => 10,
		)
	);

}
add_action( 'customize_register', 'shining_blog_customize_register' );

function shining_blog_customize_preview_js() {
	wp_enqueue_script( 'shining-blog-customizer', get_stylesheet_directory_uri() . '/assets/js/customizer.min.js', array( 'customize-preview', 'glowing-blog-customizer' ), true );
}
add_action( 'customize_preview_init', 'shining_blog_customize_preview_js' );

function shining_blog_custom_control_scripts() {
	wp_enqueue_style( 'shining-blog-customize-controls', get_theme_file_uri() . '/assets/css/customize-controls.min.css' );
	wp_enqueue_script( 'shining-blog-custom-controls-js', get_stylesheet_directory_uri() . '/assets/js/customize-control.min.js', array( 'glowing-blog-customize-control', 'jquery', 'jquery-ui-core' ), '1.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'shining_blog_custom_control_scripts' );
