<?php
/*This file is part of sheraj-biz, bc-business-consulting child theme.

All functions of this file will be loaded before of parent theme functions.
Learn more at https://codex.wordpress.org/Child_Themes.

Note: this function loads the parent stylesheet before, then child theme stylesheet
(leave it in place unless you know what you are doing.)
*/


/**
 * Activates default theme features
 */
function sheraj_biz_theme_setup(){

	// Make theme available for translation.
	// Translations can be filed in the /languages/ directory.
	// uncomment to enable (remove the // before load_theme_textdomain )
	load_theme_textdomain( 'sheraj-biz', get_stylesheet_directory() . '/languages' );

}
add_action( 'after_setup_theme', 'sheraj_biz_theme_setup' );


/**
 * Register our scripts (js/css)
 */
if( !function_exists('sheraj_biz_enqueue_scripts') ) :
add_action( 'wp_enqueue_scripts', 'sheraj_biz_enqueue_scripts',999 );
	function sheraj_biz_enqueue_scripts(){
	
		// Uncomment the line below and add a
		// scripts.js file to your child theme
		// to add custom javascript to your child theme
		wp_enqueue_style('sheraj_biz_font', sheraj_biz_slug_fonts_url(), array(), null );
		wp_dequeue_style('zerif_font');
	}
endif;


if( !function_exists('sheraj_biz_slug_fonts_url') ) :
	function sheraj_biz_slug_fonts_url() {
		$fonts_url = '';
		$font_families[] = 'Open Sans:400,300,600,700,400italic';
		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);
		$fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
		return $fonts_url;
	}
endif;

if( !function_exists('sheraj_biz_custom_header_args') ) :
	add_filter('business_consulting_custom_header_args','sheraj_biz_custom_header_args');
	function sheraj_biz_custom_header_args( $arr ){
		$arr['default-image'] = get_stylesheet_directory_uri() . '/images/custom-header.jpg';
		return $arr;
	}
endif;

/**
 * Disable things from parent
 */
add_action('wp_loaded','sheraj_biz_disable_from_parent',50);

function sheraj_biz_disable_from_parent(){
	remove_action( 'bc_business_consulting_footer_layout', 'bc_business_consulting_footer_layout',10 );
}


if( ! function_exists( 'sheraj_biz_footer_layout' ) ) :
	/**
	* Navigtion And Header Title
	*
	*/
	function sheraj_biz_footer_layout() {
	?>
   
   	<footer class="footer-main ">
    	<?php if ( is_active_sidebar( 'footer' ) ) { ?>
		<div class="container">
			<div class="row">
				<?php dynamic_sidebar( 'footer' ); ?>
			</div>
		</div>
        <?php }?>
        
		<div class="footer-bottom">
			<div class="container">
              <div class="row">
                   
                  <div class="col-md-7 col-sm-7"> 
                    
                    <div class="pull-left">
                    	<?php  echo esc_html ( bc_business_consulting_get_option('copyright_text') ); ?>
                        <a href="<?php /* translators:straing */ echo esc_url( esc_html__( 'https://wordpress.org/', 'sheraj-biz' ) ); ?>"><?php /* translators:straing */  printf( esc_html__( 'Proudly powered by %s .', 'sheraj-biz' ), 'WordPress' ); ?></a>
                        
                        <?php
                        printf( /* translators:straing */  esc_html__( 'Theme: %1$s by %2$s.', 'sheraj-biz' ), 'Sheraj Biz', '<a href="' . esc_url( __( 'https://athemeart.com', 'sheraj-biz' ) ) . '" target="_blank">' . esc_html__( 'aThemeArt', 'sheraj-biz' ) . '</a>' ); ?>
                    </div>
				  </div>
                  
                   <div class="col-md-5 col-sm-5"> 
					<?php
                    wp_nav_menu( array(
                        'theme_location'    => 'top_menu',
                        'depth'             => 1,
						'fallback_cb'    => 'bc_business_consulting_default_menu',
						'container' 	 => '',
                        )
                    );
					
                    ?>
                   </div> 
                    
			   </div>
			</div>
		</div>
	</footer><!-- Footer Main /- -->
   
     <?php
	}
	add_action( 'bc_business_consulting_footer_layout', 'sheraj_biz_footer_layout',10 );
endif;
