<?php

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function shapro_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}

add_action( 'wp_head', 'shapro_pingback_header' );

/**
 * Get the_content with limited characters
 */
if ( ! function_exists( 'shapro_getContent' ) ) {

	function shapro_getContent() {
		$theContent          = apply_filters( 'the_content', get_the_content() );
		$theContentStripTags = wp_strip_all_tags( $theContent );
		return wp_trim_words( $theContentStripTags, get_theme_mod( 'shapro_characters_length', 35 ) );
	}
}

/**
 * Get the_excerpt with limited characters
 */
if ( ! function_exists( 'shapro_getExcerpt' ) ) {

	function shapro_getExcerpt() {
		$theExcerpt          = apply_filters( 'the_excerpt', get_the_excerpt() );
		$theExcerptStripTags = wp_strip_all_tags( $theExcerpt );
		return wp_trim_words( $theExcerptStripTags, get_theme_mod( 'shapro_characters_length', 35 ) );
	}
}

add_action('shapro_ExcerptOrContent','shapro_ExcerptOrContent',10,1);

if ( ! function_exists( 'shapro_ExcerptOrContent' ) ) {

	function shapro_ExcerptOrContent($view=true) {
		if ( get_theme_mod( 'shapro_excerpt_or_content', 'excerpt' ) == 'excerpt' ) {

			if ( get_theme_mod( 'shapro_characters_option_length', 'custom' ) == 'custom' ) {
				if ( has_excerpt() ) {
					echo esc_html( shapro_getExcerpt() );
				} else {
					echo esc_html( shapro_getContent() );
				}
                if($view){
				?>
				<div class="news-blog-excerpt"><a href="<?php the_permalink(); ?>" class="more btn btn-default">
						<?php echo esc_html( get_theme_mod( 'shapro_readmore_button_txt', __( 'Read More', 'shapro' ) ) ); ?></a>
                    </div>
				<?php
                }
			} elseif ( get_theme_mod( 'shapro_characters_option_length', 'custom' ) == 'default' ) {
				the_excerpt();
			}
		} else {
			if ( get_theme_mod( 'shapro_characters_option_length', 'custom' ) == 'custom' ) {
				echo esc_html( shapro_getContent() );
                if($view){
				?>
				<div class="news-blog-excerpt"><a href="<?php the_permalink(); ?>" class="more btn btn-default">
						<?php echo esc_html( get_theme_mod( 'shapro_readmore_button_txt', __( 'Read More', 'shapro' ) ) ); ?></a>
                    </div>
				<?php
                }
			} elseif ( get_theme_mod( 'shapro_characters_option_length', 'custom' ) == 'default' ) {
				the_content( __( 'Read More', 'shapro' ) );
			}
		}
	}
}

if (! function_exists('shapro_curPageURL')) {
	function shapro_curPageURL()
	{
		$shapro_page_url = 'http';
		if (key_exists("HTTPS", $_SERVER) && ($_SERVER["HTTPS"] == "on")) {
			$shapro_page_url .= "s";
		}
		$shapro_page_url .= "://";
		if ($_SERVER["SERVER_PORT"] != "80") {
			$shapro_page_url .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
		} else {
			$shapro_page_url .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
		}
		return $shapro_page_url;
	}
}

if (!function_exists('shapro_breadcrumbs')) {

    function shapro_breadcrumbs() {

        global $post;
		$shapro_home = home_url('/');
    

        $allowed_html = array(
            'br'     => array(),
            'em'     => array(),
            'strong' => array(),
            'i'      => array(
                'class' => array(),
            ),
            'span'   => array(),
        );
        echo '<ul class="d-flex justify-content-center">';
         if (class_exists('WooCommerce')){
         if (is_home() || is_front_page()) :
            echo '<li class="breadcrumb-item"><a href="'.esc_url($shapro_home).'">'.esc_html__('Home','shapro').'</a></li>';
            echo '<li class="breadcrumb-item active"><a href="'.esc_url($shapro_home).'">'.esc_html(get_bloginfo( 'name' )).'</a></li>';
        elseif(class_exists('is_woocommerce')):
        woocommerce_breadcrumb();
         else:
            echo '<li class="breadcrumb-item"><a href="'.esc_url($shapro_home).'">'.esc_html__('Home','shapro').'</a></li>';
            // Blog Category
            if ( is_category() ) {
                echo '<li class="breadcrumb-item active"><a href="'. esc_url(shapro_curPageURL()) .'">' . esc_html__('Archive by category','shapro').' "' . single_cat_title('', false) . '"</a></li>';

            // Blog Day
            } elseif ( is_day() ) {
                echo '<li class="breadcrumb-item active"><a href="'. esc_url(get_year_link(get_the_time( __( 'Y', 'shapro' ) ))) . '">'. esc_html(get_the_time( __( 'Y', 'shapro' ) )) .'</a>';
                echo '<li class="breadcrumb-item active"><a href="'. esc_url(get_month_link( get_the_time( __( 'Y', 'shapro' ) ), get_the_time( __( 'm', 'shapro' ) )) ) .'">'. esc_html(get_the_time( __( 'F', 'shapro' ) ) ) .'</a>';
                echo '<li class="breadcrumb-item active"><a href="'. esc_url(shapro_curPageURL()) .'">'. esc_html(get_the_time( __( 'd', 'shapro' ) )) .'</a></li>';

            // Blog Month
            } elseif ( is_month() ) {
                echo '<li class="breadcrumb-item active"><a href="' . esc_url(get_year_link(get_the_time( __( 'Y', 'shapro' ) ))) . '">' . esc_html(get_the_time( __( 'Y', 'shapro' ) )) . '</a>';
                echo '<li class="breadcrumb-item active"><a href="'. esc_url(shapro_curPageURL()) .'">'. esc_html(get_the_time( __( 'F', 'shapro' ) )) .'</a></li>';

            // Blog Year
            } elseif ( is_year() ) {
                echo '<li class="breadcrumb-item active"><a href="'. esc_url(shapro_curPageURL()) .'">'. esc_html(get_the_time( __( 'Y', 'shapro' ) )) .'</a></li>';

            // Single Post
            } elseif ( is_single() && !is_attachment() && is_page('single-product') ) {
                // Custom post type
                if ( get_post_type() != 'post' ) {
                    $shapro_cat = get_the_category();
                    $shapro_cat = $shapro_cat[0];
                    echo '<li class="breadcrumb-item">';
                        echo get_category_parents($shapro_cat, TRUE, '');
                    echo '</li>';
                    echo '<li class="breadcrumb-item active"><a href="' .esc_url(shapro_curPageURL()) . '">'. esc_html(get_the_title()) .'</a></li>';
                } }
                elseif ( is_page() && $post->post_parent ) {
                $post_array = get_post_ancestors($post);

                    /**
                     * Sorts in descending order
                     */
                    krsort($post_array);

                    /**
                     * Iterate for each post Id
                     */
                    foreach($post_array as $key=>$postid){
                        /**
                         * @return object
                         */
                        $post_ids = get_post($postid);
                        /**
                         * @return string title
                         */
                        $title = $post_ids->post_title;
                        
                        echo '<li class="breadcrumb-item active"><a href="' . esc_url(get_permalink($post_ids)) . '">' . esc_html($title) . '</a></li>';
                    }
                    echo '<li class="breadcrumb-item active"><a href="'.esc_url(get_permalink()).'" >'.esc_html(get_the_title()).'</a></li>';


            }
            elseif( is_search() )
            {
                echo '<li class="breadcrumb-item active"><a href="' . esc_url(shapro_curPageURL()) . '">'. get_search_query() .'</a></li>';
            }
            elseif( is_404() )
            {
                echo '<li class="breadcrumb-item active"><a href="' . esc_url(shapro_curPageURL()) . '">'.esc_html__('Error 404','shapro').'</a></li>';
            }
            else {
                // Default
                echo '<li class="breadcrumb-item active"><a href="' . esc_url(shapro_curPageURL()) . '">'. esc_html(get_the_title(), $allowed_html ) .'</a></li>';
            }
        endif;
    }
    else{

        if (is_home() || is_front_page()) :
            echo '<li class="breadcrumb-item"><a href="'.esc_url($shapro_home).'">'.esc_html__('Home','shapro').'</a></li>';
            echo '<li class="breadcrumb-item active"><a href="'.esc_url($shapro_home).'">'.esc_html(get_bloginfo( 'name' )).'</a></li>';
         else:
            echo '<li class="breadcrumb-item"><a href="'.esc_url($shapro_home).'">'.esc_html__('Home','shapro').'</a></li>';
            // Blog Category
            if ( is_category() ) {
                echo '<li class="breadcrumb-item active"><a href="'. esc_url(shapro_curPageURL()) .'">' . esc_html__('Archive by category','shapro').' "' . single_cat_title('', false) . '"</a></li>';

            // Blog Day
            } elseif ( is_day() ) {
                echo '<li class="breadcrumb-item active"><a href="'. esc_url(get_year_link(get_the_time( __( 'Y', 'shapro' ) ))) . '">'. esc_html(get_the_time( __( 'Y', 'shapro' ) )) .'</a>';
                echo '<li class="breadcrumb-item active"><a href="'. esc_url(get_month_link( get_the_time( __( 'Y', 'shapro' ) ), get_the_time( __( 'm', 'shapro' ) )) ) .'">'. esc_html(get_the_time( __( 'F', 'shapro' ) ) ) .'</a>';
                echo '<li class="breadcrumb-item active"><a href="'. esc_url(shapro_curPageURL()) .'">'. esc_html(get_the_time( __( 'd', 'shapro' ) )) .'</a></li>';

            // Blog Month
            } elseif ( is_month() ) {
                echo '<li class="breadcrumb-item active"><a href="' . esc_url(get_year_link(get_the_time( __( 'Y', 'shapro' ) ))) . '">' . esc_html(get_the_time( __( 'Y', 'shapro' ) )) . '</a>';
                echo '<li class="breadcrumb-item active"><a href="'. esc_url(shapro_curPageURL()) .'">'. esc_html(get_the_time( __( 'F', 'shapro' ) )) .'</a></li>';

            // Blog Year
            } elseif ( is_year() ) {
                echo '<li class="breadcrumb-item active"><a href="'. esc_url(shapro_curPageURL()) .'">'. esc_html(get_the_time( __( 'Y', 'shapro' ) )) .'</a></li>';

            // Single Post
            } elseif ( is_single() && !is_attachment() && is_page('single-product') ) {
                // Custom post type
                if ( get_post_type() != 'post' ) {
                    $shapro_cat = get_the_category();
                    $shapro_cat = $shapro_cat[0];
                    echo '<li class="breadcrumb-item">';
                        echo get_category_parents($shapro_cat, TRUE, '');
                    echo '</li class="breadcrumb-item">';
                    echo '<li class="breadcrumb-item active"><a href="' .esc_url(shapro_curPageURL()) . '">'. esc_html(get_the_title()) .'</a></li>';
                } }
                elseif ( is_page() && $post->post_parent ) {
                $post_array = get_post_ancestors($post);

                    /**
                     * Sorts in descending order
                     */
                    krsort($post_array);

                    /**
                     * Iterate for each post Id
                     */
                    foreach($post_array as $key=>$postid){
                        /**
                         * @return object
                         */
                        $post_ids = get_post($postid);
                        /**
                         * @return string title
                         */
                        $title = $post_ids->post_title;
                        /* permalink */
                        echo '<li class="breadcrumb-item active"><a href="' . esc_url(get_permalink($post_ids)) . '">' . esc_html($title) . '</a></li>';
                    }
                    echo '<li class="breadcrumb-item active"><a href="'.esc_url(get_permalink()).'" >'.esc_html(get_the_title()).'</a></li>';


            }
            elseif( is_search() )
            {
                echo '<li class="breadcrumb-item active"><a href="' . esc_url(shapro_curPageURL()) . '">'. get_search_query() .'</a></li>';
            }
            elseif( is_404() )
            {
                echo '<li class="breadcrumb-item active"><a href="' . esc_url(shapro_curPageURL()) . '">'.esc_html__('Error 404','shapro').'</a></li>';
            }
            else {
                // Default
                echo '<li class="breadcrumb-item active"><a href="' . esc_url(shapro_curPageURL()) . '">'. esc_html(get_the_title(), $allowed_html ) .'</a></li>';
            }
        endif;
    }
    echo '</ul>';


    }
    

}

if ( ! function_exists( 'shapro_page_title' ) ) {

	function shapro_page_title() {
		if ( is_archive() ) {
			$shapro_archive = get_theme_mod( 'shapro_archive_prefix', esc_html__( 'Archive:', 'shapro' ) );

			if ( is_day() ) :

				printf( esc_html__( '%1$s %2$s', 'shapro' ), esc_html( $shapro_archive ), esc_html( get_the_date() ) );

			elseif ( is_month() ) :

				printf( esc_html__( '%1$s %2$s', 'shapro' ), esc_html( $shapro_archive ), esc_html( get_the_date() ) );

			elseif ( is_year() ) :

				printf( esc_html__( '%1$s %2$s', 'shapro' ), esc_html( $shapro_archive ), esc_html( get_the_date() ) );

			elseif ( is_category() ) :

				$shapro_category = get_theme_mod( 'shapro_category_prefix', esc_html__( 'Category:', 'shapro' ) );

				printf( esc_html__( '%1$s %2$s', 'shapro' ), esc_html( $shapro_category ), single_cat_title( '', false ) );

			elseif ( is_tag() ) :

				$shapro_tag_text = get_theme_mod( 'shapro_tag_prefix', esc_html__( 'Tag:', 'shapro' ) );

				printf( esc_html__( '%1$s %2$s', 'shapro' ), esc_html( $shapro_tag_text ), single_tag_title( '', false ) );

			elseif ( is_author() ) :

				$shapro_author = get_theme_mod( 'shapro_author_prefix', esc_html__( 'All posts by:', 'shapro' ) );

				printf( esc_html__( '%1$s %2$s', 'shapro' ), esc_html( $shapro_author ), esc_html( get_the_author() ) );

			elseif ( class_exists( 'WooCommerce' ) && is_shop() ) :

				$shapro_shop = get_theme_mod( 'shapro_shop_prefix', esc_html__( 'Shop', 'shapro' ) );

				printf( esc_html__( '%1$s %2$s', 'shapro' ), esc_html( $shapro_shop ), single_tag_title( '', false ) );

			elseif ( is_archive() ) :
				the_archive_title( '<h1>', '</h1>' );

			endif;
		} elseif ( is_search() ) {
			$shapro_search = get_theme_mod( 'search_prefix', __( 'Search results for:', 'shapro' ) );

			printf( esc_html__( '%1$s %2$s', 'shapro' ), esc_html( $shapro_search ), get_search_query() );
		} elseif ( is_404() ) {
			$shapro_404 = get_theme_mod( '404_prefix', __( '404: Page not found', 'shapro' ) );
			printf( esc_html__( '%1$s %2$s', 'shapro' ), esc_html( $shapro_404 ), '' );
		} else {
			the_title();
		}
	}
}

if ( ! function_exists( 'has_item_in_menu' ) ) {


	function has_item_in_menu() {
		$has_menu_items = wp_nav_menu(
			array(
				'theme_location' => 'primary',
				'echo'           => false,
			)
		) !== false;

		// check if menu location is assigned
		$is_assigned = has_nav_menu( 'primary' );

		// check for both conditions
		if ( ! ( $has_menu_items && $is_assigned ) ) {
			return 'flex-row-reverse';
		} return;
	}
}

if ( ! function_exists( 'has_item_in_menu_mobile' ) ) {


	function has_item_in_menu_mobile() {
		$has_menu_items = wp_nav_menu(
			array(
				'theme_location' => 'primary',
				'echo'           => false,
			)
		) !== false;

		// check if menu location is assigned
		$is_assigned = has_nav_menu( 'primary' );

		// check for both conditions
		return (  $has_menu_items && $is_assigned )  ? true : false;
	}
}
