<?php
/**
 *  Settings for general customizer.
 *
 * @package Shapro
 */

/**
 * This function used to add customizer section & control.
 *
 * @param object $wp_customize the customizer manager.
 */
function shapro_gen_customizer_setting( $wp_customize ) {

	$wp_customize->add_panel(
		'shapro_gen_setting',
		array(
			'priority'   => 30,
			'capability' => 'edit_theme_options',
			'title'      => __( 'General', 'shapro' ),
		)
	);

	/* Blog Section */
	$wp_customize->add_section(
		'shapro_general_blog_Section',
		array(
			'priority' => 1,
			'title'    => __( 'Blogs', 'shapro' ),
			'panel'    => 'shapro_gen_setting',
		)
	);

	/* Color Section */
	$wp_customize->add_section(
		'colors',
		array(
			'priority' => 1,
			'title'    => __( 'Colors', 'shapro' ),
			'panel'    => 'shapro_gen_setting',
		)
	);

	$wp_customize->get_setting( 'background_color' )->default = '#ffffff';

	$wp_customize->add_setting(
		'shapro_excerpt_or_content',
		array(
			'default'           => esc_html__( 'excerpt', 'shapro' ),
			'sanitize_callback' => 'shapro_sanitize_select',
		)
	);

	$wp_customize->add_control(
		'shapro_excerpt_or_content',
		array(
			'label'   => esc_html__( 'Choose Options', 'shapro' ),
			'section' => 'shapro_general_blog_Section',
			'type'    => 'radio',
			'choices' => array(
				'excerpt' => esc_html__( 'Excerpt', 'shapro' ),
				'content' => esc_html__( 'Content', 'shapro' ),
			),
		)
	);

	$wp_customize->add_setting(
		'shapro_characters_option_length',
		array(
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'shapro_sanitize_select',
			'default'           => 'custom',
		)
	);

	$wp_customize->add_control(
		'shapro_characters_option_length',
		array(
			'type'        => 'select',
			'section'     => 'shapro_general_blog_Section', // Add a default or your own section
			'label'       => __( 'Characters length', 'shapro' ),
			'description' => __( 'Recommended to use custom lenght of 35. This character length will also be applied to blog section of the homepage template.', 'shapro' ),
			'choices'     => array(
				'default' => __( 'Default', 'shapro' ),
				'custom'  => __( 'Custom', 'shapro' ),
			),
		)
	);

	$wp_customize->add_setting(
		'shapro_characters_length',
		array(
			'default'           => 35,
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'absint',
		)
	);
	$wp_customize->add_control(
		'shapro_characters_length',
		array(
			'label'           => esc_html__( 'Length', 'shapro' ),
			'section'         => 'shapro_general_blog_Section',
			'active_callback' => 'shapro_for_custom_len',
			'input_attrs'     => array(
				'min'  => 10,
				'max'  => 250,
				'step' => 1,
			),
			'type'            => 'number',
		)
	);

	// date
	$wp_customize->add_setting(
		'date_meta_display',
		array(
			'default'           => true,
			'sanitize_callback' => 'shapro_switch_sanitization',
		)
	);
	$wp_customize->add_control(
		new Shapro_Toggle_Switch_Custom_Control(
			$wp_customize,
			'date_meta_display',
			array(
				'label'   => __( 'Date', 'shapro' ),
				'section' => 'shapro_general_blog_Section',
			)
		)
	);

	// author
	$wp_customize->add_setting(
		'author_meta_display',
		array(
			'default'           => true,
			'sanitize_callback' => 'shapro_switch_sanitization',
		)
	);
	$wp_customize->add_control(
		new Shapro_Toggle_Switch_Custom_Control(
			$wp_customize,
			'author_meta_display',
			array(
				'label'   => __( 'Author', 'shapro' ),
				'section' => 'shapro_general_blog_Section',
			)
		)
	);

	// category
	$wp_customize->add_setting(
		'cat_meta_display',
		array(
			'default'           => true,
			'sanitize_callback' => 'shapro_switch_sanitization',
		)
	);
	$wp_customize->add_control(
		new Shapro_Toggle_Switch_Custom_Control(
			$wp_customize,
			'cat_meta_display',
			array(
				'label'   => __( 'Category', 'shapro' ),
				'section' => 'shapro_general_blog_Section',
			)
		)
	);

	// Button: Read More
	$wp_customize->add_setting(
		'shapro_readmore_button_txt',
		array(
			'capability'        => 'edit_theme_options',
			'default'           => 'Read More',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'shapro_readmore_button_txt',
		array(
			'type'        => 'text',
			'section'     => 'shapro_general_blog_Section', // Add a default or your own section
			'label'       => __( 'Button Text', 'shapro' ),
			'description' => __( 'This button text will also be applied to blog section of the homepage template', 'shapro' ),
		)
	);

	if ( ! function_exists( 'shapro_for_custom_len' ) ) {

		function shapro_for_custom_len( $control ) {
			if ( $control->manager->get_setting( 'shapro_characters_option_length' )->value() == 'custom' ) {
				return true;
			}
			return false;
		}
	}

	if ( ! function_exists( 'shapro_switch_sanitization' ) ) {

		function shapro_switch_sanitization( $input ) {
			if ( true === $input ) {
				return 1;
			} else {
				return 0;
			}
		}
	}

	if ( ! function_exists( 'shapro_sanitize_select' ) ) {

		function shapro_sanitize_select( $input, $setting ) {
			$input   = sanitize_key( $input );
			$choices = $setting->manager->get_control( $setting->id )->choices;
			return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
		}
	}
}

add_action( 'customize_register', 'shapro_gen_customizer_setting' );
