<?php
function shapro_footer_customizer_setting( $wp_customize ){
	$wp_customize->add_panel(
		'shapro_footer_setting',
		array(
			'capability' => 'edit_theme_options',
			'title'      => __( 'Footer', 'shapro' ),
		)
	);

	$wp_customize->add_section(
		'shapro_footer_bar',
		array(
			'title' => __( 'Footer Bar', 'shapro' ),
			'panel' => 'shapro_footer_setting',
		)
	);		

	$wp_customize->add_setting(
		'copyright_display',
		array(
			'default'   => true,
			'transport' => 'refresh',
			'sanitize_callback' => 'shapro_switch_sanitization',
		)
	);
	$wp_customize->add_control(
		new Shapro_Toggle_Switch_Custom_Control(
			$wp_customize,
			'copyright_display',
			array(
				'label'   => __( 'Display', 'shapro' ),
				'section' => 'shapro_footer_bar',
			)
		)
	);

	$wp_customize->add_setting(
		'copyright_text',
		array(
			/* translators: 1: theme name, 2: theme url. */
			'default'           => sprintf( esc_html__( 'Theme: %1$s by %2$s', 'shapro' ), 'Shapro', '<a href="https://unibirdtech.com/">Unibird Tech</a>' ),
			'transport'         => 'refresh',
			'sanitize_callback' => 'wp_kses_post',
		)
	);
	$wp_customize->add_control(
		'copyright_text',
		array(
			'label'   => __( 'Copyright Text', 'shapro' ),
			'section' => 'shapro_footer_bar',
			'type'    => 'textarea',
		)
	);
		/**
		 * copyright_text
		 */
		$wp_customize->selective_refresh->add_partial(
			'copyright_text',
			array(
				'selector'        => '.site-info',
				'settings'        => 'copyright_text',
				'render_callback' => function () {
					return get_theme_mod( 'copyright_text' );
				},
			)
		);

		if (!function_exists('shapro_switch_sanitization')) {

			function shapro_switch_sanitization($input) {
				if (true === $input) {
					return 1;
				} else {
					return 0;
				}
			}
	
		}

    
		
	}
add_action( 'customize_register', 'shapro_footer_customizer_setting' );