<?php
/**
 *  This is settings for header breadcrumb.
 *
 * @package Shapro
 */

/**
 * A global instance manage customizer settings.
 *
 * @param WP_Customize_Manager $wp_customize    Manager instance.
 * Function run test way.
 */
function shapro_customizer_breadcrumb( $wp_customize ) {
	$wp_customize->add_section(
		'shapro_breadcrumb_setting',
		array(
			'title'       => esc_html__( 'Archive page title', 'shapro' ),
			'description' => esc_html__( 'Here you can set the prefix to the breadcrumb title for all Archive pages or can leave empty', 'shapro' ),
		)
	);

	$wp_customize->add_setting(
		'shapro_archive_prefix',
		array(
			'default'           => esc_html__( 'Archive:', 'shapro' ),
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'shapro_archive_prefix',
		array(
			'label'   => esc_html__( 'Archive', 'shapro' ),
			'section' => 'shapro_breadcrumb_setting',
			'type'    => 'text',
		)
	);

	$wp_customize->add_setting(
		'shapro_category_prefix',
		array(
			'default'           => esc_html__( 'Category:', 'shapro' ),
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'shapro_category_prefix',
		array(
			'label'   => esc_html__( 'Category', 'shapro' ),
			'section' => 'shapro_breadcrumb_setting',
			'type'    => 'text',
		)
	);

	$wp_customize->add_setting(
		'shapro_tag_prefix',
		array(
			'default'           => esc_html__( 'Tag:', 'shapro' ),
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'shapro_tag_prefix',
		array(
			'label'   => esc_html__( 'Tag', 'shapro' ),
			'section' => 'shapro_breadcrumb_setting',
			'type'    => 'text',
		)
	);

	$wp_customize->add_setting(
		'shapro_author_prefix',
		array(
			'default'           => esc_html__( 'All posts by:', 'shapro' ),
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'shapro_author_prefix',
		array(
			'label'   => esc_html__( 'Author', 'shapro' ),
			'section' => 'shapro_breadcrumb_setting',
			'type'    => 'text',
		)
	);

	$wp_customize->add_setting(
		'shapro_search_prefix',
		array(
			'default'           => esc_html__( 'Search results for:', 'shapro' ),
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'shapro_search_prefix',
		array(
			'label'   => esc_html__( 'Search', 'shapro' ),
			'section' => 'shapro_breadcrumb_setting',
			'type'    => 'text',
		)
	);

	$wp_customize->add_setting(
		'shapro_404_prefix',
		array(
			'default'           => esc_html__( '404: Page not found', 'shapro' ),
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'shapro_404_prefix',
		array(
			'label'   => esc_html__( '404', 'shapro' ),
			'section' => 'shapro_breadcrumb_setting',
			'type'    => 'text',
		)
	);

	$wp_customize->add_setting(
		'shapro_shop_prefix',
		array(
			'default'           => esc_html__( 'Shop', 'shapro' ),
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'shapro_shop_prefix',
		array(
			'label'   => esc_html__( 'Shop', 'shapro' ),
			'section' => 'shapro_breadcrumb_setting',
			'type'    => 'text',
		)
	);
}

add_action( 'customize_register', 'shapro_customizer_breadcrumb' );
