<?php

/**
 * Handles front end setup.
 *
 * @package Shapro
 */

/**
 * Class Shapro_Public
 */
class Shapro_Public {

	public function enqueue_scripts() {

		wp_enqueue_script( 'jquery' );
		// Bootstrap
		if ( ! is_rtl() ) {
			wp_enqueue_style( 'shapro-bootstrap', SHAPRO_DIR_URI . '/assets/css/bootstrap.css' );
		} else {
			wp_enqueue_style( 'shapro-bootstrap-rtl', SHAPRO_DIR_URI . '/assets/css/bootstrap-rtl.css' );
		}
		wp_enqueue_style( 'shapro-skin', SHAPRO_DIR_URI . '/assets/css/skin/theme-default.css' );

		global $is_IE;
		if ( $is_IE ) {
			wp_enqueue_style( 'shapro-one-style', SHAPRO_DIR_URI . '/assets/css/ie.css' );
		} else {
			wp_enqueue_style( 'shapro-style', get_stylesheet_uri() );
		}
		// RTL styles.
		wp_style_add_data( 'shapro-style', 'rtl', 'replace' );
		wp_enqueue_style( 'smartmenus', SHAPRO_DIR_URI . '/assets/css/bootstrap-smartmenus.css' );

		if ( ! is_rtl() ) {
			wp_enqueue_script( 'shapro-bootstrap-js', SHAPRO_DIR_URI . '/assets/js/bootstrap.js' );
		} else {
			wp_enqueue_script( 'shapro-bootstrap-rtl', SHAPRO_DIR_URI . '/assets/js/bootstrap-rtl.js' );
		}

		wp_enqueue_script( 'smartmenus-js', SHAPRO_DIR_URI . '/assets/js/jquery.smartmenus.js' );
		wp_enqueue_script( 'smartmenus-bootstrap', SHAPRO_DIR_URI . '/assets/js/jquery.smartmenus.bootstrap.js' );
		wp_enqueue_script( 'owl-carousel', SHAPRO_DIR_URI . '/assets/js/owl.carousel.js' );
		wp_enqueue_style( 'font-awesome', SHAPRO_DIR_URI . '/assets/css/font-awesome.css' );

		/**
		 * Slider
		 */
		if ( ! is_rtl() ) {
			wp_enqueue_script( 'shapro-slider', SHAPRO_DIR_URI . '/assets/js/slider.js' );
		} else {
			wp_enqueue_script( 'shapro-slider-rtl', SHAPRO_DIR_URI . '/assets/js/slider-rtl.js' );
		}

		wp_enqueue_script( 'shapro-main', SHAPRO_DIR_URI . '/assets/js/main.js' );
		wp_enqueue_style( 'font-awesome', SHAPRO_DIR_URI . '/assets/css/font-awesome.css' );

		// Main Stylesheet
		wp_style_add_data( 'shapro_style', 'rtl', 'replace' );

		wp_enqueue_style( 'shapro-animate', SHAPRO_DIR_URI . '/assets/css/animate.css' );
		wp_enqueue_style( 'shapro-owl-carousel', SHAPRO_DIR_URI . '/assets/css/owl.carousel.css' );

		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		wp_enqueue_style( 'style-base', SHAPRO_DIR_URI . '/assets/css/style-base.css' );
	}

	/**
	 * Register widgets for the theme.
	 *
	 * @since    Shapro 1.0
	 * @modified 0.3.6
	 */
	public function initialize_widgets() {

		register_sidebar(
			array(
				'name'          => esc_html__( 'Sidebar', 'shapro' ),
				'id'            => 'sidebar-1',
				'before_widget' => '<div id="%1$s" class="widget shapro-widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3>',
				'after_title'   => '</h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__( 'Footer', 'shapro' ),
				'id'            => 'footer_widget_area',
				'before_widget' => '<div class="col-md-3"><div id="%1$s" class="widget shapro-widget %2$s">',
				'after_widget'  => '</div></div>',
				'before_title'  => '<h4 class="widget-title widget-title-1">',
				'after_title'   => '</h4>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__( 'WooCommerce sidebar', 'shapro' ),
				'id'            => 'woocommerce',
				'description'   => esc_html__( 'Drap and drop WooCommerce widgets here', 'shapro' ),
				'before_widget' => '<div id="%1$s" class="widget shapro-widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3>',
				'after_title'   => '</h3>',
			)
		);
	}

	/**
	 * Setup the theme.
	 *
	 * @since Shapro 1.0
	 */
	public function setup_theme() {

		$GLOBALS['content_width'] = apply_filters( 'shapro_content_width', 640 );

		$logo_settings = array(
			'height'      => 55,
			'width'       => 150,
			'flex-height' => true,
			'flex-width'  => true,
		);

		$custom_background_settings = array(
			'default-color' => apply_filters( 'shapro_default_background_color', 'E5E5E5' ),
		);

		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'custom-logo', $logo_settings );
		add_theme_support( 'html5', array( 'search-form' ) );
		add_theme_support( 'custom-background', $custom_background_settings );
		add_theme_support( 'header-footer-elementor' );

		// woocommerce support

		add_theme_support( 'woocommerce' );

		// Woocommerce Gallery Support
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );
		add_theme_support( 'align-wide' );
		add_theme_support( 'responsive-embeds' );
		load_theme_textdomain( 'shapro', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'primary' => __( 'Primary Menu', 'shapro' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'shapro_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		add_editor_style();
	}

}

/**
 * @todo shift to admin class
 */

// Enqueue For Admin css and js
function shapro_admin_enqueue_scripts() {
	wp_enqueue_style( 'shapro-admin-style', SHAPRO_DIR_URI . '/assets/css/admin.css' );
	wp_enqueue_script( 'shapro-admin-script', SHAPRO_DIR_URI . '/assets/js/shapro-admin-script.js' );
	wp_localize_script(
		'shapro-admin-script',
		'shapro_ajax_object',
		array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
	);
}

add_action( 'admin_enqueue_scripts', 'shapro_admin_enqueue_scripts' );

function shapro_menu() {
	?>
	<script>
		jQuery('a,input').bind('focus', function () {
			if (!jQuery(this).closest(".menu-item").length && (jQuery(window).width() <= 992)) {
				jQuery('.navbar-collapse').removeClass('show');
			}
		})
	</script>
	<?php

}

add_action( 'wp_footer', 'shapro_menu' );
