<?php

/**
 * Shapro functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package
 */
define( 'SHAPRO_DIR', get_template_directory() );
define( 'SHAPRO_DIR_URI', get_template_directory_uri() );
define( 'SHAPRO_INCLUDE', trailingslashit( SHAPRO_DIR ) . 'inc/' );
define( 'SHAPRO_BASE_DIR', SHAPRO_INCLUDE . 'core/' );

require SHAPRO_BASE_DIR . "class-shapro-public.php";
require SHAPRO_BASE_DIR . "class-shapro-admin.php";
require SHAPRO_INCLUDE . "customizer/class-shapro-pro-info-control.php";
require SHAPRO_INCLUDE . "customizer/class-shapro-toggle-switch-custom-control.php";

/**
 * Public
 */
$shapro_front = new Shapro_Public();
add_action( 'wp_enqueue_scripts', array( $shapro_front, 'enqueue_scripts' ) );
add_action( 'after_setup_theme', array( $shapro_front, 'setup_theme' ) );
add_action( 'widgets_init', array( $shapro_front, 'initialize_widgets' ) );
/**
 * Admin
 */
$shapro_admin = new Shapro_Admin();
add_action( 'customize_register', array( $shapro_admin, 'shapro_pro_info' ) );
add_action( 'customize_preview_init', array( $shapro_admin, 'shapro_preview_register' ) );
add_action( 'customize_controls_print_scripts', array( $shapro_admin, 'shapro_theme_customizer' ) );

require get_template_directory() . '/inc/custom-header.php';
/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require_once get_template_directory() . '/inc/plugin-install.php';

/* Header */
require get_template_directory() . '/inc/customizer/customizer-header.php';

/* Recommended plugin */
require get_template_directory() . '/inc/customizer/customizer_recommended_plugin.php';

/* Header */
require get_template_directory() . '/inc/customizer/customizer-general.php';

/*
 * Breadcrumb
 */
require get_template_directory() . '/inc/customizer/customizer-breadcrumb.php';

require_once get_template_directory() . '/inc/class-shapro-bootstrap-navwalker.php';

/* Footer */
require get_template_directory() . '/inc/customizer/customizer-footer.php';