<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Shapro
 */
?>
<footer>
    <div class="inner">
        <?php if (is_active_sidebar('footer_widget_area')) { ?>
            <div class="top">
                <div class="container">
                    <div class="row">
                        <?php dynamic_sidebar('footer_widget_area'); ?>
                    </div>
                </div>
            </div>
        <?php } elseif (current_user_can('edit_theme_options')) { {
                ?>
                <div class="top">
                    <div class="container">
                        <div class="row">
                            <a data-customizer-event="shapro-footer-sidebar-event" id="shapro-footer-widget-to-add" class="m-auto" href='<?php echo esc_url(admin_url('widgets.php')); ?>'>
                                <?php esc_html_e('Click to assign widgets here.', 'shapro'); ?>
                            </a>
                            </p>
                        </div>
                    </div>
                </div>
            <?php }
        }
        ?>

        <?php
        if(get_theme_mod('copyright_display', 1)) {
        ?>
        <div class="bottom">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <div class="site-info">
                        <?php
                            /* translators: 1: theme name, 2: theme url. */
                            $shapro_defaultCopyRight = get_theme_mod('copyright_text', sprintf( esc_html__( 'Theme: %1$s by %2$s', 'shapro' ), 'Shapro', '<a href="https://unibirdtech.com/">Unibird Tech</a>' ));
                            echo wp_kses_post($shapro_defaultCopyRight);
                        ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>
</footer>
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
