<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( ! function_exists( 'servicio_enqueue_scripts' ) ) :
    /**
     * Load assets.
     *
     * @since 1.0.0
     */
    function servicio_enqueue_scripts() {
    	$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
        wp_enqueue_style( 'kontor-style-parent', get_template_directory_uri() . '/style.css' );
        wp_enqueue_style( 'servicio-style', get_stylesheet_directory_uri() . '/style.css', array( 'kontor-style-parent' ), '1.0.0' );
    }
endif;
add_action( 'wp_enqueue_scripts', 'servicio_enqueue_scripts', 99 );

/**
 * Register custom fonts.
 */
function servicio_fonts_url() {
	$fonts_url = '';
	$fonts     = array();
	$subsets   = 'latin,latin-ext';

	/* translators: If there are characters in your language that are not supported by Lota, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Lota font: on or off', 'servicio' ) ) {
		$fonts[] = 'Lota';
	}


	/* translators: If there are characters in your language that are not supported by Ubuntu, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Ubuntu font: on or off', 'servicio' ) ) {
		$fonts[] = 'Ubuntu';
	}

	if ( $fonts ) {
		$fonts_url = add_query_arg( array(
			'family' => urlencode( implode( '|', $fonts ) ),
			'subset' => urlencode( $subsets ),
		), 'https://fonts.googleapis.com/css' );
	}

	return esc_url_raw( $fonts_url );
}



if ( ! function_exists( 'servicio_customize_backend_styles' ) ) :
    /**
     * Load assets.
     *
     * @since 1.0.0
     */
    function servicio_customize_backend_styles() {
        wp_enqueue_style( 'servicio-style', get_stylesheet_directory_uri() . '/customizer-style.css' );
    }
endif;
add_action( 'customize_controls_enqueue_scripts', 'servicio_customize_backend_styles', 99 );