<?php
/**
 * Sample implementation of the Custom Header feature.
 *
 * @link https://developer.wordpress.org/themes/functionality/custom-headers/
 */

function seos_video_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'seos_video_custom_header_args', array(
		'default-image'          => get_template_directory_uri() . '/images/header.png',
		'default-text-color'     => 'CEBF94',
		'width'                  => 1300,
		'height'                 => 100,
		'flex-height'            => true,
		'wp-head-callback'       => 'seos_video_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'seos_video_custom_header_setup' );

// РЕГИСТРИРАНЕ НА СНИМКАТА И ОПИСАНИЕ С ПРЕВОД, СЛЕД КАТО СА НАЛИЧНИ ПРЕВОДИТЕ
function seos_video_register_default_headers() {
	register_default_headers( array(
		'yourimg' => array(
			'url'           => get_template_directory_uri() . '/images/header.png',
			'thumbnail_url' => get_template_directory_uri() . '/images/header.png',
			'description'   => _x( 'Default Image', 'header image description', 'seos-video' ),
		),
	) );
}
add_action( 'init', 'seos_video_register_default_headers' );

if ( ! function_exists( 'seos_video_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog.
 */
function seos_video_header_style() {
	$seos_video_header_text_color = get_header_textcolor();
	?>
	<style type="text/css">
	<?php if ( ! display_header_text() ) : ?>
		.site-title,
		.site-description {
			position: absolute;
			clip: rect(1px, 1px, 1px, 1px);
		}
	<?php else : ?>
		header .site-branding .site-title a,
		.site-description {
			color: #<?php echo esc_attr( $seos_video_header_text_color ); ?>;
		}
	<?php endif; ?>
	</style>
	<?php
}
endif;
