<?php
/**
 * Template Name: Home Custom Page
 */
?>

<?php get_header(); ?>

<main id="main" role="main">
  <?php do_action( 'security_guard_services_above_banner' ); ?>

  <section id="banner">
    <div class="container">
      <div class="bannerprofileimg">
          <div class="slide_svgbx ">
              <div class="sli_imgbx luzuk-slide-img-curve">
                <?php 
                  $banner_profile_img = get_theme_mod('banner_profile_img');

                  if(!empty($banner_profile_img)){
                    echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($banner_profile_img).'" class="img-responsive secondry-bg-img " />';
                  }else{
                    echo '<img alt="banner_profile_img" src="' . esc_url(get_template_directory_uri() . '/assets/images/bann.png') . '" class="img-responsive " />';
                  }
                ?>
              </div>
          </div>
      </div>
      <div class="content">
        <h4>
          <?php echo esc_html(get_theme_mod('security_guard_services_banner_heading','YOUR TRUSTED PARTNER')); ?>
        </h4>
      
      <div class=" btmbanner">
        <div class="row mr-0">
        <div class="l-hs">
          <p>
            <?php echo esc_html(get_theme_mod('security_guard_services_banner_description','At SecurityForce, we deliver unparalleled protection services tailored to your needs.')); ?>
          </p>
        </div>
        <div class="m-hs">
          <h4>
            <?php echo esc_html(get_theme_mod('security_guard_services_banner_headingbtm','IN SECURITY')); ?>
          </h4>
        </div>
        <div class="r-hs">
          <!-- <a href="</?php echo esc_url(get_theme_mod('security_guard_services_banner_videolink', '#')); ?>"> -->
            <div class="video">
              <?php 
                $banner_video_thumbnailimg = get_theme_mod('banner_video_thumbnailimg');

                if(!empty($banner_video_thumbnailimg)){
                  echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($banner_video_thumbnailimg).'" class="img-responsive secondry-bg-img" />';
                }else{
                  echo '<img alt="banner_video_thumbnailimg" src="' . esc_url(get_template_directory_uri() . '/assets/images/slidrhs.png') . '" class="img-responsive" />';
                }
              ?>
        
              <?php     
                  $iframe = get_theme_mod('security_guard_services_banner_videolink', 'Add your video embed code in customizer');
              ?>
                <?php if( get_theme_mod('video_button_display','show' ) == 'show') :?>
                <div class="bttn">                  
                  <div class="video-pop">
                      <a class="popup-youtube" id="video-pop">                             
                                    <i class="fa fa-play"></i>  
                      </a> 
                      <div id="popup" class="popup">
                          <div class="popup-content">
                              <span id="closePopup">&times;</span>
                              <?php echo $iframe; ?>
                          </div>
                      </div>
                  </div>                  
                  <div class="clearfix"></div>
                </div>
                <?php endif ?>
          </div>
        
      </div>
      
    </div>
    <div class="b-btn">
          <a href="<?php echo esc_url(get_theme_mod('security_guard_services_banner_btnlink', '#')); ?>">
            <?php echo esc_html(get_theme_mod('security_guard_services_banner_btntext', 'Request A Quote')); ?>
            <i class="fa-solid fa-arrow-right"></i>
          </a>
        </div>
  </div>
  </div>
    <script type="text/javascript">
  document.getElementById("video-pop").addEventListener("click", function() {
      const popup = document.getElementById("popup");
      const popupContent = popup.querySelector(".popup-content");

      popup.classList.add("show");
      popupContent.classList.add("show");
  });

  document.getElementById("closePopup").addEventListener("click", function() {
      const popup = document.getElementById("popup");
      const popupContent = popup.querySelector(".popup-content");
      const videoIframe = popupContent.querySelector("iframe"); // Select the iframe inside the popup

      popupContent.classList.remove("show");
      popup.classList.remove("show");

      // Stop the video by resetting the src attribute
      videoIframe.src = videoIframe.src;
  });

</script>
  </section>

  <?php do_action( 'security_guard_services_below_banner' ); ?>

    <section id="feature" >
      <div class="container">
        <div class="featurebx">
            <!-- <div id="feature-con" >  -->
              <?php $security_guard_services_content_pages_feature = array();
                for ( $count = 1; $count <= 4; $count++ ) {

                  $mod = intval( get_theme_mod( 'security_guard_services_feature_page' . $count ));
                  if ( 'page-none-selected' != $mod ) {
                    $security_guard_services_content_pages_feature[] = $mod;
                  }
                }
                if( !empty($security_guard_services_content_pages_feature) ) :
                  $args = array(
                    'post_type' => 'page',
                    'post__in' => $security_guard_services_content_pages_feature,
                    'orderby' => 'post__in'
                  );
                  $query = new WP_Query( $args );
                if ( $query->have_posts() ) :
                  $i = 1;

              ?>     

              <div class="row mr-0">
                <?php  while ( $query->have_posts() ) : $query->the_post(); ?>
                  <div class="col-lg-3 col-md-6 col-sm-6 feabx">
                      <div class="feabxinn">  
                          <div class="single-fea">               
                              <div class="imagebx">
                                  <?php the_post_thumbnail(); ?>
                              </div>
                              <div class="content">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="69.43" height="73.545" viewBox="0 0 69.43 73.545">
  <path id="Path_1024" data-name="Path 1024" d="M78.186,91.177c-10.85,4.226-20.523.98-28.158-5.754-7.666,6.711-17.3,9.993-28.2,5.754L15.294,95.8l.057,1.622A98.014,98.014,0,0,0,20,121.806c6.994,21.583,16.238,28.64,28.534,36.252l1.471.909,1.471-.909c12.3-7.612,21.539-14.668,28.534-36.252a98.023,98.023,0,0,0,4.652-24.387l.059-1.623Z" transform="translate(-15.294 -85.423)" fill="#ffd200"/>
</svg>
                                  <div class="icnbx">
                                    <i class="<?php echo esc_attr(get_theme_mod('security_guard_services_feature_icon' . $i, 'fa fa-home')); ?>"></i>
                                  </div>
                                  <h1><?php the_title(); ?></h1>
                                  <p>
                                    <?php $security_guard_services_excerpt = get_the_excerpt(); echo esc_html( security_guard_services_string_limit_words( $security_guard_services_excerpt,20 ) ); ?>
                                  </p>
                              </div>
                            </div>
                      </div>
                  </div>
                <?php $i++; endwhile; 
                wp_reset_postdata();?>
              </div>
              <?php else : ?>
                <div class="no-postfound"></div>
              <?php endif;
              endif;?>
            <!-- </div>    -->
        </div>
        <div class="clearfix"></div>
      </div>
    </section>

  <?php do_action( 'security_guard_services_below_feature' ); ?>

    <section id="aboutus">
      <div class="container">
        <div class="row mr-0">
          <div class="abt-imgbx">
            <div class="abt-img">
              <?php 
                $aboutus_image = get_theme_mod('aboutus_image');

                if(!empty($aboutus_image)){
                  echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($aboutus_image).'" class="img-responsive secondry-bg-img" />';
                }else{
                  echo '<img alt="aboutus_image" src="' . esc_url(get_template_directory_uri() . '/assets/images/about.jpg') . '" class="img-responsive" />';
                }
              ?>
            </div>
          </div>
          <div class="conbx">
              <h6>
                  <svg xmlns="http://www.w3.org/2000/svg" width="30" height="38" viewBox="0 0 69.43 73.545">
                    <path id="Path_1024" data-name="Path 1024" d="M78.186,91.177c-10.85,4.226-20.523.98-28.158-5.754-7.666,6.711-17.3,9.993-28.2,5.754L15.294,95.8l.057,1.622A98.014,98.014,0,0,0,20,121.806c6.994,21.583,16.238,28.64,28.534,36.252l1.471.909,1.471-.909c12.3-7.612,21.539-14.668,28.534-36.252a98.023,98.023,0,0,0,4.652-24.387l.059-1.623Z" transform="translate(-15.294 -85.423)" fill="#ffd200"/>
                  </svg>
                  <?php echo esc_html(get_theme_mod('security_guard_services_aboutus_subheading','About Us')); ?>
              </h6>
              <h4>
                <?php echo esc_html(get_theme_mod('security_guard_services_aboutus_heading1','YOUR TRUSTED PARTNER')); ?><br>
                <span><?php echo esc_html(get_theme_mod('security_guard_services_aboutus_heading2','IN SECURITY')); ?></span>
              </h4>
              <p>
                <?php echo esc_html(get_theme_mod('security_guard_services_aboutus_description','There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words hidden in the middle of text.')); ?>
              </p>
              <div class=" aboutuscontact">
                <div class="row mr-0">
                  <div class="col-lg-6 col-md-12 col-sm-12 pl-0">             
                      <li>
                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 69.43 73.545">
                          <path id="Path_1024" data-name="Path 1024" d="M78.186,91.177c-10.85,4.226-20.523.98-28.158-5.754-7.666,6.711-17.3,9.993-28.2,5.754L15.294,95.8l.057,1.622A98.014,98.014,0,0,0,20,121.806c6.994,21.583,16.238,28.64,28.534,36.252l1.471.909,1.471-.909c12.3-7.612,21.539-14.668,28.534-36.252a98.023,98.023,0,0,0,4.652-24.387l.059-1.623Z" transform="translate(-15.294 -85.423)" fill="#ffd200"/>
                        </svg>
                        <?php echo esc_html(get_theme_mod('security_guard_services_aboutus_list1','24/7 Availability')); ?>
                      </li>
                      <li>
                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 69.43 73.545">
                          <path id="Path_1024" data-name="Path 1024" d="M78.186,91.177c-10.85,4.226-20.523.98-28.158-5.754-7.666,6.711-17.3,9.993-28.2,5.754L15.294,95.8l.057,1.622A98.014,98.014,0,0,0,20,121.806c6.994,21.583,16.238,28.64,28.534,36.252l1.471.909,1.471-.909c12.3-7.612,21.539-14.668,28.534-36.252a98.023,98.023,0,0,0,4.652-24.387l.059-1.623Z" transform="translate(-15.294 -85.423)" fill="#ffd200"/>
                        </svg>
                        <?php echo esc_html(get_theme_mod('security_guard_services_aboutus_list2','14 Year of Experience')); ?>
                      </li>
                  </div>
                  <div class="col-lg-6 col-md-12 col-sm-12 pl-0">          
                      <li>
                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 69.43 73.545">
                          <path id="Path_1024" data-name="Path 1024" d="M78.186,91.177c-10.85,4.226-20.523.98-28.158-5.754-7.666,6.711-17.3,9.993-28.2,5.754L15.294,95.8l.057,1.622A98.014,98.014,0,0,0,20,121.806c6.994,21.583,16.238,28.64,28.534,36.252l1.471.909,1.471-.909c12.3-7.612,21.539-14.668,28.534-36.252a98.023,98.023,0,0,0,4.652-24.387l.059-1.623Z" transform="translate(-15.294 -85.423)" fill="#ffd200"/>
                        </svg>
                        <?php echo esc_html(get_theme_mod('security_guard_services_aboutus_list3','Trained Professionals')); ?>
                      </li>
                      <li>
                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 69.43 73.545">
                          <path id="Path_1024" data-name="Path 1024" d="M78.186,91.177c-10.85,4.226-20.523.98-28.158-5.754-7.666,6.711-17.3,9.993-28.2,5.754L15.294,95.8l.057,1.622A98.014,98.014,0,0,0,20,121.806c6.994,21.583,16.238,28.64,28.534,36.252l1.471.909,1.471-.909c12.3-7.612,21.539-14.668,28.534-36.252a98.023,98.023,0,0,0,4.652-24.387l.059-1.623Z" transform="translate(-15.294 -85.423)" fill="#ffd200"/>
                        </svg>
                        <?php echo esc_html(get_theme_mod('security_guard_services_aboutus_list4','Advanced Technology')); ?>
                      </li> 
                  </div>
                </div>
              </div>
              <div class="abtbtn">
                <a href="<?php echo esc_url(get_theme_mod('security_guard_services_aboutus_btnlink', '#')); ?>">
                  <?php echo esc_html(get_theme_mod('security_guard_services_aboutus_btntext','Request A Quote')); ?>
                  <i class="fa-solid fa-arrow-right"></i>
                </a>
              </div>
              <div class="yearofexpreince">
                    <h2> <span> <?php echo esc_html(get_theme_mod('security_guard_services_aboutus_yearofexprience_number','21')); ?> </span> <?php echo esc_html(get_theme_mod('security_guard_services_aboutus_yearofexprience_numbertxt','YEARS')); ?> </h2>
                    <h5><?php echo esc_html(get_theme_mod('security_guard_services_aboutus_yearofexprience_text','OF EXPERIENCE')); ?></h5>
              </div>
          </div>
        </div>
      </div>
    </section>

  <?php do_action( 'security_guard_services_below_aboutus'); ?>

  <div class="container entry-content py-4">
    <?php while ( have_posts() ) : the_post(); ?>
      <?php the_content(); ?>
    <?php endwhile; // end of the loop. ?>
  </div>
</main>
<?php get_footer(); ?>