<?php
/**
 * Display Header.
 * @package Security Guard Services
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<?php if ( function_exists( 'wp_body_open' ) ) {
	    wp_body_open();
	} else {
	    do_action( 'wp_body_open' );
	}?>
	<header role="banner" class="banner">
		<a class="screen-reader-text skip-link" href="#main"><?php esc_html_e( 'Skip to content', 'security-guard-services' ); ?></a>
		<div id="header">
			<div class="container pd-0">
				<div class="header-box">
					<div class="row marrgin-0">
						<div class="col-lg-3 col-md-6 col-sm-6 col-5 logobx-out">
							<div class="logobx">
								<!-- <div class="logobxinn"></div> -->
								<?php get_template_part( 'template-parts/header/site', 'branding' ); ?>
							</div>
						</div>
						<div class="col-lg-9 col-md-6 col-sm-6 col-7"> 
							<div class="row mr-0">
								<div class="col-lg-8 col-md-4 col-sm-4 col-4">
									<div class="menu-section text-lg-center">
										<div class="<?php if( get_theme_mod( 'security_guard_services_sticky_header', false) != '') { ?>sticky-menubox<?php } else { ?>close-sticky <?php } ?>">
											<?php get_template_part( 'template-parts/navigation/site', 'nav' ); ?>
										</div>
									</div>
								</div>
								<div class="col-lg-4 col-md-8 col-sm-8 col-8 pd-0">
									<div class="contactusbtn">
										<?php if(get_theme_mod('security_guard_header_btnphonnum_text', '123-456-789') != ''){ ?>
											<a href="tel:<?php echo esc_html(get_theme_mod('security_guard_header_btnphonnum_text', '123-456-789')); ?>">
												<span> <?php echo esc_html('Call Us : ', 'security-guard-services'); ?> </span>	
												<?php echo esc_html(get_theme_mod('security_guard_header_btnphonnum_text', '123-456-789')); ?> 
											</a>
										<?php }?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</header>

	<?php if(is_singular()) {?>
		<div class="inner-head">
			<img src="<?php if ( get_header_image() ){ echo esc_url(get_header_image()); } else { echo esc_url(get_template_directory_uri()) ?>/assets/images/head-bg.jpg<?php }?>" class="head-img" alt="<?php echo esc_html('Header Background Image', 'security-guard-services'); ?>">
			<div class="container">
				<div class="row">
					<div class="col-lg-6 col-md-6 align-self-center">
						<div class="header-content">
							<h1><?php single_post_title(); ?></h1>
							<div class="lt-breadcrumbs">
								<?php security_guard_services_breadcrumb(); ?>
							</div>
						</div>
					</div>
					<?php if(has_post_thumbnail()){?>
						<div class="col-lg-6 col-md-6 align-self-end">
							
						</div>
					<?php }?>
				</div>
				
			</div>
		</div>
	<?php }?>