<?php
/**
 * Jetpack Compatibility File
 * See: https://jetpack.me/
 *
 * @package Seasonal
 */

/**
 * Add theme support for Infinite Scroll.
 * See: https://jetpack.me/support/infinite-scroll/
 */
function seasonal_jetpack_setup() {
	add_theme_support( 'infinite-scroll', array(
		'container' => 'main',
		'render'    => 'seasonal_infinite_scroll_render',
		'footer'    => 'page',
	) );
} // end function seasonal_jetpack_setup
add_action( 'after_setup_theme', 'seasonal_jetpack_setup' );

function seasonal_infinite_scroll_render() {
	while ( have_posts() ) {
		the_post();
		get_template_part( 'template-parts/content', get_post_format() );
	}
} // end function seasonal_infinite_scroll_render