<?php
/**
 * The template for displaying archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Seasonal
 */

get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main"  itemscope="" itemtype="http://schema.org/Blog">
		<?php get_sidebar( 'breadcrumbs' ); ?>

		<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<?php
					seasonal_the_archive_title( '<h1 class="page-title">', '</h1>' );
					seasonal_archive_description( '<div class="taxonomy-description">', '</div>' );
				?>
			</header><!-- .page-header -->

			
			<?php while ( have_posts() ) : the_post(); ?>

				<?php
					/* Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					get_template_part( 'template-parts/content', get_post_format() );
				?>

			<?php endwhile; ?>

			<?php 
				// load nav when the blog has more than one page of summaries.
				seasonal_blog_pagination();
			?>

		<?php else : ?>

			<?php get_template_part( 'content', 'none' ); ?>

		<?php endif; ?>


        	<?php get_template_part( 'template-parts/site-footer' ); ?>
            
		</main><!-- #main -->
	</div><!-- #primary -->

<?php get_footer(); ?>