<?php
/**
 * Title: School - Default Header
 * Slug: school/header-default
 * Categories: blockstrap-site-header
 * Viewport Width: 1280
 */

$logo = get_theme_file_uri( 'assets/images/logo-black.png' ); /* <?php echo esc_url( $logo ); ?> */
$home_url = get_home_url(); /* <?php echo esc_url( $home_url ); ?> */

$blog_page_id = get_option( 'page_for_posts' ); /* <?php echo absint($blog_page_id); ?> */

$theme_slug  = get_template();
$page_status = function_exists( 'blockstrap_get_option' ) ? blockstrap_get_option( 'blockstrap_demo_pages' ) : get_option( 'blockstrap_demo_pages' );

$page_about = !empty($page_status[$theme_slug]['about']) ? absint($page_status[$theme_slug]['about']) : 0; /* <?php echo absint($page_about); ?> */
$page_courses = !empty($page_status[$theme_slug]['courses']) ? absint($page_status[$theme_slug]['courses']) : 0; /* <?php echo absint($page_courses); ?> */
$page_contact = !empty($page_status[$theme_slug]['contact']) ? absint($page_status[$theme_slug]['contact']) : 0; /* <?php echo absint($page_contact); ?> */
?>


<!-- wp:blockstrap/blockstrap-widget-skip-links {"content":""} -->
[bs_skip_links text1='Skip to main content'  hash1='main'  text2=''  hash2=''  text3=''  hash3=''  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size=''  shadow=''  css_class='' ]
<!-- /wp:blockstrap/blockstrap-widget-skip-links -->

<!-- wp:blockstrap/blockstrap-widget-navbar {"bg":"custom-color","bg_color":"rgba(255,255,255,0.84)","bgtus":true,"cscos":true,"inner_container":"container","mb_lg":"","pr":"2","pl":"2","border":"0","position":"fixed-top"} -->
[bs_navbar bg='custom-color'  bg_color='rgba(255,255,255,0.84)'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_image_xy='{x:undefined,y:undefined}'  bgtus='true'  cscos='true'  container=''  inner_container='container'  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr='2'  pb=''  pl='2'  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border='0'  rounded=''  rounded_size=''  shadow=''  position='fixed-top'  sticky_offset_top=''  sticky_offset_bottom='' ]<nav class="navbar navbar-expand-lg pe-2 ps-2 border-0 bg-custom-color bg-transparent-until-scroll color-scheme-flip-on-scroll fixed-top" style="background-color:rgba(255,255,255,0.84)"><div class="wp-block-blockstrap-blockstrap-widget-navbar container"><!-- wp:blockstrap/blockstrap-widget-navbar-brand {"text":"","icon_image":"<?php echo esc_url( $logo ); ?>","img_max_width":160,"custom_url":"/","brand_font_size":"h1","brand_font_weight":"font-weight-normal","brand_font_italic":"font-italic","bg_gradient":"linear-gradient(135deg,rgb(34,227,7) 0%,rgb(245,245,245) 100%)","bg_on_text":true,"mb_lg":"","pt_lg":"0","pr_lg":"3","pb_lg":"0","rounded_size":"lg"} -->
        [bs_navbar_brand text=''  icon_image='<?php echo esc_url( $logo ); ?>'  img_max_width='160'  type='home'  custom_url='/'  text_color=''  brand_font_size='h1'  brand_font_weight='font-weight-normal'  brand_font_italic='font-italic'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgb(34,227,7) 0%,rgb(245,245,245) 100%)'  bg_on_text='true'  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='0'  pr_lg='3'  pb_lg='0'  pl_lg=''  border=''  rounded=''  rounded_size='lg'  shadow=''  css_class='' ]<a class="navbar-brand d-flex align-items-center pt-0 pe-3 pb-0 rounded-lg" href="<?php echo esc_url( $home_url ); ?>"><img class="" alt="Site logo" src="<?php echo esc_url( $logo ); ?>" style="max-width:160px" width="160" height="50"/><span class="mb-0 props.attributes.brand_font_size props.attributes.brand_font_weight fst-italic"></span></a>[/bs_navbar_brand]
        <!-- /wp:blockstrap/blockstrap-widget-navbar-brand -->

        <!-- wp:blockstrap/blockstrap-widget-nav {"anchor":"main-nav","inside_navbar":"1","font_size":"0","ml_lg":"","rounded_size":"lg","width":"w-100"} -->
        [bs_nav anchor='main-nav'  inside_navbar='1'  container=''  flex_direction=''  nav_style=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  nav_fill=''  font_size='0'  font_size_custom=''  bg=''  mt=''  mr='auto'  mb=''  ml='auto'  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg='0'  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size='lg'  shadow=''  width='w-100'  css_class='' ]<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav_main-nav" aria-label="Open menu"><span class="navbar-toggler-icon"></span></button><div class="wp-block-blockstrap-blockstrap-widget-nav blockstrap-nav collapse navbar-collapse" id="navbarNav_main-nav"><ul class="wp-block-blockstrap-blockstrap-widget-nav navbar-nav me-auto ms-auto me-lg-0 rounded-lg w-100 0"><!-- wp:blockstrap/blockstrap-widget-nav-item {"custom_url":"#home","text":"Home","text_color":"dark","ml":"0","ml_md":"0","ml_lg":"auto","content":""} -->
                [bs_nav_item type='home'  page_id=''  post_id=''  custom_url='#home'  text='Home'  icon_class=''  icon_aria_label=''  link_type=''  link_size=''  link_bg=''  link_pt=''  link_pr=''  link_pb=''  link_pl=''  link_pt_md=''  link_pr_md=''  link_pb_md=''  link_pl_md=''  link_pt_lg=''  link_pr_lg=''  link_pb_lg=''  link_pl_lg=''  link_divider=''  text_color='dark'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  font_weight=''  mt=''  mr=''  mb=''  ml='0'  mt_md=''  mr_md=''  mb_md=''  ml_md='0'  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg='auto'  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size=''  shadow=''  visibility_conditions=''  css_class='' ]
                <!-- /wp:blockstrap/blockstrap-widget-nav-item -->

				<!-- wp:blockstrap/blockstrap-widget-nav-item {"type":"page","page_id":"<?php echo absint($page_courses); ?>","custom_url":"#courses","text":"Courses","text_color":"dark","content":""} -->
				[bs_nav_item type='page'  page_id='<?php echo absint($page_courses); ?>'  post_id=''  custom_url='#courses'  text='Courses'  icon_class=''  icon_aria_label=''  link_type=''  link_size=''  link_bg=''  link_pt=''  link_pr=''  link_pb=''  link_pl=''  link_pt_md=''  link_pr_md=''  link_pb_md=''  link_pl_md=''  link_pt_lg=''  link_pr_lg=''  link_pb_lg=''  link_pl_lg=''  link_divider=''  text_color='dark'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  font_weight=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size=''  shadow=''  visibility_conditions=''  css_class='' ]
				<!-- /wp:blockstrap/blockstrap-widget-nav-item -->

				<!-- wp:blockstrap/blockstrap-widget-nav-item {"type":"page","page_id":"<?php echo absint($page_about); ?>","custom_url":"#about","text":"About","text_color":"dark","content":""} -->
				[bs_nav_item type='page'  page_id='<?php echo absint($page_about); ?>'  post_id=''  custom_url='#about'  text='About'  icon_class=''  icon_aria_label=''  link_type=''  link_size=''  link_bg=''  link_pt=''  link_pr=''  link_pb=''  link_pl=''  link_pt_md=''  link_pr_md=''  link_pb_md=''  link_pl_md=''  link_pt_lg=''  link_pr_lg=''  link_pb_lg=''  link_pl_lg=''  link_divider=''  text_color='dark'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  font_weight=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size=''  shadow=''  visibility_conditions=''  css_class='' ]
				<!-- /wp:blockstrap/blockstrap-widget-nav-item -->

				<!-- wp:blockstrap/blockstrap-widget-nav-item {"type":"page","page_id":"<?php echo absint( $blog_page_id ); ?>","text":"Blog","content":""} -->
				[bs_nav_item type='page'  page_id='<?php echo absint( $blog_page_id ); ?>'  post_id=''  custom_url=''  text='Blog'  icon_class=''  icon_aria_label=''  link_type=''  link_size=''  link_bg=''  link_pt=''  link_pr=''  link_pb=''  link_pl=''  link_pt_md=''  link_pr_md=''  link_pb_md=''  link_pl_md=''  link_pt_lg=''  link_pr_lg=''  link_pb_lg=''  link_pl_lg=''  link_divider=''  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  font_weight=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size=''  shadow=''  visibility_conditions=''  css_class='' ]
				<!-- /wp:blockstrap/blockstrap-widget-nav-item -->

				<!-- wp:blockstrap/blockstrap-widget-nav-item {"type":"page","page_id":"<?php echo absint($page_contact); ?>","custom_url":"#contact","text":"Contact","text_color":"dark","content":""} -->
				[bs_nav_item type='page'  page_id='<?php echo absint($page_contact); ?>'  post_id=''  custom_url='#contact'  text='Contact'  icon_class=''  icon_aria_label=''  link_type=''  link_size=''  link_bg=''  link_pt=''  link_pr=''  link_pb=''  link_pl=''  link_pt_md=''  link_pr_md=''  link_pb_md=''  link_pl_md=''  link_pt_lg=''  link_pr_lg=''  link_pb_lg=''  link_pl_lg=''  link_divider=''  text_color='dark'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  font_weight=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size=''  shadow=''  visibility_conditions=''  css_class='' ]
				<!-- /wp:blockstrap/blockstrap-widget-nav-item -->

                <!-- wp:blockstrap/blockstrap-widget-nav-item {"type":"lightbox","page_id":"<?php echo absint($blog_page_id); ?>","custom_url":"#apply-now-form","text":"Apply Now","icon_class":"fa-solid fa-graduation-cap","link_type":"btn","link_size":"large","link_bg":"primary","text_color":"white","content":""} -->
                [bs_nav_item type='lightbox'  page_id='<?php echo absint($blog_page_id); ?>'  post_id=''  custom_url='#apply-now-form'  text='Apply Now'  icon_class='fa-solid fa-graduation-cap'  icon_aria_label=''  link_type='btn'  link_size='large'  link_bg='primary'  link_pt=''  link_pr=''  link_pb=''  link_pl=''  link_pt_md=''  link_pr_md=''  link_pb_md=''  link_pl_md=''  link_pt_lg=''  link_pr_lg=''  link_pb_lg=''  link_pl_lg=''  link_divider=''  text_color='white'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  font_weight=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size=''  shadow=''  visibility_conditions=''  css_class='' ]
                <!-- /wp:blockstrap/blockstrap-widget-nav-item --></ul></div>[/bs_nav]
        <!-- /wp:blockstrap/blockstrap-widget-nav --></div></nav>[/bs_navbar]
<!-- /wp:blockstrap/blockstrap-widget-navbar -->