<?php

if ( class_exists( 'BlockStrap_Admin' ) ) {


	class BlockStrap_Admin_Child extends BlockStrap_Admin {
		public function __construct() {
			parent::__construct();
		}

		/**
		 * Get the theme title.
		 *
		 * @return string|null
		 */
		public function get_theme_title() {
			return __( 'School', 'school' );
		}

		/**
		 * Get the array of demo pages.
		 *
		 * @return array[]
		 */
		public function get_demo_pages() {
			return array(
				'about'   => array(
					'title' => __( 'About', 'school' ),
					'slug'  => 'about',
					'desc'  => $this->get_template_content( dirname( __FILE__ ) . '/../patterns/about-page.php' ),
				),
				'courses' => array(
					'title' => __( 'Courses', 'school' ),
					'slug'  => 'courses',
					'desc'  => $this->get_template_content( dirname( __FILE__ ) . '/../patterns/courses-page.php' ),
				),
				'contact' => array(
					'title' => __( 'Contact Us', 'school' ),
					'slug'  => 'contact',
					'desc'  => $this->get_template_content( dirname( __FILE__ ) . '/../patterns/contact-page.php' ),
				),
				'blog'    => array(
					'title'   => __( 'Our Blog', 'school' ),
					'slug'    => 'blog',
					'desc'    => $this->get_template_content( dirname( __FILE__ ) . '/../patterns/blog-page.php' ),
					'is_blog' => true,
				),
			);
		}


	}

}