<?php
/**
 * The sidebar containing the main widget area.
 *
 * @package ScholarsGate
 */


?>

<aside id="secondary" class="widget-area" role="complementary">
	<?php dynamic_sidebar( 'primary-sidebar' ); ?>
</aside><!-- #secondary -->

<?php if ( ! is_active_sidebar( 'primary-sidebar' ) ) { ?>

	<aside id="secondary" class="widget-area" role="complementary">
		<!-- Search -->
		<aside id="search-3" class="widget widget_search">
			<h2 class="widget-title"><?php esc_html_e('Search Here', 'scholarsgate'); ?></h2>
			<?php get_search_form(); ?>
		</aside>
		<!-- Categories -->
		<aside id="categories" class="widget widget_categories" role="complementary" aria-label="<?php esc_attr_e( 'secondsidebar', 'scholarsgate' ); ?>">
		    <h2 class="widget-title"><?php esc_html_e('Categories', 'scholarsgate'); ?></h2>
		    <ul>
		        <?php
		        $args = array(
		            'title_li' => '',
		        );
		        wp_list_categories($args);
		        ?>
		    </ul>
		</aside>
		<!-- Archive -->
		<aside id="archive" class="widget widget_archive" role="complementary" aria-label="<?php esc_attr_e( 'secondsidebar', 'scholarsgate' ); ?>">
		    <h2 class="widget-title"><?php esc_html_e('Archive List', 'scholarsgate'); ?></h2>
		    <ul>
		        <?php wp_get_archives('type=monthly'); ?>
		    </ul>
		</aside>
		<!-- Tag Sidebar -->
		<aside id="tag-sidebar" class="widget widget_tag_cloud" role="complementary" aria-label="<?php esc_attr_e( 'thirdsidebar', 'scholarsgate' ); ?>">
		    <h2 class="widget-title"><?php esc_html_e('Popular Tags', 'scholarsgate'); ?></h2>
		    <div class="tagcloud">
		        <?php
		        $scholarsgate_tags = get_tags(array(
		            'orderby' => 'count',
		            'order'   => 'DESC',
		            'number'  => 20, // You can change the number of tags displayed
		        ));

		        if ($scholarsgate_tags) {
		            foreach ($scholarsgate_tags as $scholarsgate_tag) {
		                $scholarsgate_tag_link = get_tag_link($scholarsgate_tag->term_id);
		                $scholarsgate_tag_name = $scholarsgate_tag->name;
		                $scholarsgate_tag_count = $scholarsgate_tag->count;
		                echo '<a href="' . esc_url($scholarsgate_tag_link) . '" class="tag-link" title="' . esc_attr($scholarsgate_tag_name) . ' (' . $scholarsgate_tag_count . ' posts)">' . esc_html($scholarsgate_tag_name) . '</a> ';
		            }
		        } else {
		            echo '<p>' . esc_html__('No tags found.', 'scholarsgate') . '</p>';
		        }
		        ?>
		    </div>
		</aside>	
	</aside>

<?php } ?>